/*
 * Decompiled with CFR 0.152.
 */
package org.mule.dx.contributions.scaffolding.handler;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.mule.apikit.scaffolding.api.ScaffoldingDependency;
import org.mule.dx.contributions.scaffolding.MavenDependencyModelImpl;
import org.mule.dx.contributions.scaffolding.handler.DependenciesHandler;
import org.mule.dx.platform.api.WorkspaceManager;
import org.mule.dx.platform.api.dependency.DependencyModel;
import org.mule.dx.platform.api.dependency.DependencyModelManager;
import org.mule.dx.platform.api.graphql.GraphQlClient;
import org.mule.dx.platform.api.maven.MavenDependencyModel;
import org.mule.dx.platform.api.project.Project;
import org.mule.tools.apikit.model.MuleConfig;
import org.mule.tools.apikit.model.MuleConfigBuilder;

public class ProjectHandler {
    public static final String MULE_APP_XML_FOLDER = "src/main/mule";
    public static final String MULE_APP_RESOURCES_FOLDER = "src/main/resources";
    private final WorkspaceManager workspaceManager;
    private final DependenciesHandler dependenciesHandler;

    public ProjectHandler(WorkspaceManager workspaceManager, GraphQlClient graphQlClient) {
        this.workspaceManager = workspaceManager;
        this.dependenciesHandler = new DependenciesHandler(graphQlClient);
    }

    public ProjectHandler(WorkspaceManager workspaceManager, DependenciesHandler dependenciesHandler) {
        this.workspaceManager = workspaceManager;
        this.dependenciesHandler = dependenciesHandler;
    }

    private Project getProject(String projectId) {
        if (StringUtils.isBlank((CharSequence)projectId)) {
            throw new RuntimeException("Project ID cannot be null");
        }
        Optional iProject = this.workspaceManager.getProjectById(projectId);
        return (Project)iProject.orElseThrow(() -> new RuntimeException(String.format("Project ID %s does not exist", projectId)));
    }

    public List<MuleConfig> getMuleConfigFiles(String projectId) {
        return this.listConfigFiles(projectId).stream().map(ProjectHandler::mapToMuleConfig).collect(Collectors.toList());
    }

    public Set<String> getMuleConfigFilepaths(String projectId) {
        return this.listConfigFiles(projectId).stream().map(File::toPath).map(this.getProjectBasePath(projectId)::relativize).map(Path::toString).collect(Collectors.toSet());
    }

    public Set<String> getMuleResourceFilepaths(String projectId) {
        return this.listResources(projectId).stream().map(File::toPath).map(this.getProjectBasePath(projectId)::relativize).map(Path::toString).collect(Collectors.toSet());
    }

    private Collection<File> listConfigFiles(String projectId) {
        return this.listProjectFiles(projectId, MULE_APP_XML_FOLDER, "xml");
    }

    private Collection<File> listResources(String projectId) {
        return this.listProjectFiles(projectId, MULE_APP_RESOURCES_FOLDER, new String[0]);
    }

    private Collection<File> listProjectFiles(String projectId, String projectFolder, String ... allowedExtensions) {
        Project project = this.getProject(projectId);
        URI location = project.getLocation();
        if (location == null) {
            throw new RuntimeException("API location cannot be null");
        }
        URI folderURI = null;
        try {
            folderURI = new URI(location.toString() + projectFolder);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        if (allowedExtensions.length == 0) {
            allowedExtensions = null;
        }
        return FileUtils.listFiles((File)new File(folderURI), (String[])allowedExtensions, (boolean)true);
    }

    private static MuleConfig mapToMuleConfig(File file) {
        try {
            MuleConfig muleConfig = MuleConfigBuilder.fromStream((InputStream)new FileInputStream(file));
            muleConfig.setName(file.getName());
            return muleConfig;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void addRequiredDependencies(String projectId, String classifier) {
        this.dependenciesHandler.addDependencies(this.getProject(projectId), classifier);
    }

    public void addRequiredDependencies(String projectId, String classifier, List<ScaffoldingDependency> scaffoldingDependencies) {
        this.dependenciesHandler.addDependencies(this.getProject(projectId), classifier, scaffoldingDependencies);
    }

    public List<String> persistScaffoldingConfigs(String projectId, List<MuleConfig> configs) throws IOException {
        Map<String, InputStream> files = configs.stream().collect(Collectors.toMap(MuleConfig::getName, MuleConfig::getContent));
        return this.writeFilesToProject(projectId, MULE_APP_XML_FOLDER, files);
    }

    public List<String> writeFilesToProject(String projectId, String projectPath, Map<String, InputStream> files) throws IOException {
        ArrayList<String> muleConfigUris = new ArrayList<String>();
        Path basePath = Paths.get(this.getProjectBasePath(projectId).toString(), projectPath);
        Files.createDirectories(basePath, new FileAttribute[0]);
        for (Map.Entry<String, InputStream> config : files.entrySet()) {
            URI uri = basePath.resolve(config.getKey()).toUri();
            try (FileOutputStream outStream = new FileOutputStream(new File(uri));){
                config.getValue().transferTo(outStream);
            }
            muleConfigUris.add(uri.toString());
        }
        return muleConfigUris;
    }

    public Path getProjectBasePath(String projectId) {
        Project project = this.getProject(projectId);
        return Paths.get(project.getLocation());
    }

    public void updateDependencyClassifier(String projectId, String groupId, String artifactId, String version, String newClassifier) throws RuntimeException {
        Project project = this.getProject(projectId);
        DependencyModelManager modelManager = (DependencyModelManager)project.getComponent(DependencyModelManager.class).orElseThrow(() -> new RuntimeException("Failed to update dependency classifier"));
        modelManager.mutator().ifPresent(mutator -> {
            MavenDependencyModel existingDependency = this.dependenciesHandler.findDependency((DependencyModelManager<MavenDependencyModel>)modelManager, groupId, artifactId, version);
            if (existingDependency != null) {
                mutator.removeDependency((DependencyModel)existingDependency);
                MavenDependencyModelImpl updatedDependency = new MavenDependencyModelImpl(existingDependency);
                updatedDependency.setClassifier(newClassifier);
                mutator.addDependency((DependencyModel)updatedDependency);
                mutator.persist();
            }
        });
    }
}

