/*
 * Decompiled with CFR 0.152.
 */
package org.mule.dx.contributions.scaffolding;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultConnectorsProperties {
    private static final Logger logger = LoggerFactory.getLogger(DefaultConnectorsProperties.class);
    private static final String PROPERTIES_FILE = "default-connectors.properties";
    private static final String MISSING_VERSION = "0.0.0";
    private static final Map<String, String> connectorVersions = new HashMap<String, String>();

    public static void loadPropertiesFromFile(String propertiesFile) throws IOException {
        try (InputStream input = DefaultConnectorsProperties.class.getClassLoader().getResourceAsStream(propertiesFile);){
            if (input == null) {
                throw new IOException("Could not find " + propertiesFile);
            }
            DefaultConnectorsProperties.loadProperties(input);
        }
    }

    public static void loadProperties(InputStream input) throws IOException {
        Properties props = new Properties();
        props.load(input);
        String allDeps = props.getProperty("all");
        if (allDeps != null) {
            for (String dep : allDeps.split(",")) {
                String[] parts = dep.trim().split(":");
                if (parts.length != 3) continue;
                connectorVersions.put(parts[0] + ":" + parts[1], parts[2]);
            }
        }
    }

    public static String getVersion(String groupId, String artifactId) {
        return connectorVersions.getOrDefault(groupId + ":" + artifactId, MISSING_VERSION);
    }

    static {
        try {
            DefaultConnectorsProperties.loadPropertiesFromFile(PROPERTIES_FILE);
        }
        catch (IOException e) {
            logger.error("Error loading default-connectors.properties: {}", (Object)e.getMessage());
        }
    }
}

