/*
 * Decompiled with CFR 0.152.
 */
package org.mule.dx.contributions.scaffolding.handler;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionException;
import org.mule.dx.contributions.exception.ComponentException;
import org.mule.dx.contributions.exception.ScaffoldingException;
import org.mule.dx.contributions.scaffolding.model.ScaffoldError;
import org.mule.dx.contributions.scaffolding.model.ScaffoldResponse;

public class ResponseHandler {
    private ResponseHandler() {
    }

    public static ScaffoldResponse createErrorResponse(Throwable genericError) {
        CompletionException completionException;
        if (genericError == null) {
            return ResponseHandler.createErrorResponse(new Exception("Unknown error occurred"));
        }
        ScaffoldResponse.ScaffoldResponseBuilder responseBuilder = new ScaffoldResponse.ScaffoldResponseBuilder();
        Throwable cause = genericError;
        while (cause instanceof CompletionException && (completionException = (CompletionException)cause).getCause() != null) {
            cause = completionException.getCause();
        }
        if (cause instanceof ScaffoldingException) {
            ScaffoldingException scaffoldingException = (ScaffoldingException)cause;
            List<String> errorMessages = scaffoldingException.getErrorMessages();
            List<String> stackTraces = scaffoldingException.getErrorStackTraces();
            for (int i = 0; i < errorMessages.size(); ++i) {
                String error2 = errorMessages.get(i);
                String stackTrace = i < stackTraces.size() ? stackTraces.get(i) : "";
                responseBuilder.withError(new ScaffoldError(error2, stackTrace));
            }
        } else {
            StringWriter sw = new StringWriter();
            cause.printStackTrace(new PrintWriter(sw));
            String stackTrace = sw.toString();
            ComponentException.from(cause).getErrorMessages().stream().map(error -> new ScaffoldError((String)error, stackTrace)).forEach(responseBuilder::withError);
        }
        return responseBuilder.build();
    }

    public static ScaffoldResponse createSuccessResponse(List<String> muleConfigUris, Map<String, List<String>> additionalInformation) {
        return new ScaffoldResponse.ScaffoldResponseBuilder().withMuleConfigUris(muleConfigUris).withAdditionalInformation(additionalInformation).build();
    }

    public static ScaffoldResponse createSuccessResponse(List<String> muleConfigUris) {
        return ResponseHandler.createSuccessResponse(muleConfigUris, new HashMap<String, List<String>>());
    }
}

