%dw 2.0
import getProtocols from scripts::asyncapi::AsyncApiModule
import filterTypes from scripts::modules::ApiGraphModule

input api application/json
output application/java

fun isAsyncAPI(api) = !isEmpty(api."@graph" filterTypes ["apiContract:AsyncAPI"])

fun getContainsAVROScheme(api): Boolean = do {
    var payloads = api."@graph" filterTypes ["apiContract:Payload"]
    ---
    if (!isEmpty(payloads))
        !isEmpty(payloads filter $."apiContract:schemaMediaType"? and startsWith($."apiContract:schemaMediaType", "application/vnd.apache.avro"))
    else
        false
}
---
{
    ("protocols": getProtocols(api)) if isAsyncAPI(api),
    "schemes": [
        ("AVRO") if (getContainsAVROScheme(api))
    ]
}
