/*
 * Decompiled with CFR 0.152.
 */
package amf.core.client.scala.transform;

import amf.core.client.common.transform.PipelineId$;
import amf.core.client.scala.AMFGraphConfiguration;
import amf.core.client.scala.AMFResult;
import amf.core.client.scala.errorhandling.AMFErrorHandler;
import amf.core.client.scala.model.document.BaseUnit;
import amf.core.client.scala.transform.TransformationPipeline;
import amf.core.client.scala.transform.TransformationPipelineRunner;
import amf.core.internal.validation.CoreValidations$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Map;

public final class AMFTransformer$ {
    public static AMFTransformer$ MODULE$;

    static {
        new AMFTransformer$();
    }

    public AMFResult transform(BaseUnit unit, AMFGraphConfiguration configuration) {
        return this.transform(unit, PipelineId$.MODULE$.Default(), configuration);
    }

    public AMFResult transform(BaseUnit unit, String pipelineName, AMFGraphConfiguration configuration) {
        BaseUnit baseUnit;
        Map<String, TransformationPipeline> pipelines = configuration.registry().getTransformationPipelines();
        Option pipeline = pipelines.get(pipelineName);
        AMFErrorHandler handler = configuration.errorHandlerProvider().errorHandler();
        Option option = pipeline;
        if (option instanceof Some) {
            Some some = (Some)option;
            TransformationPipeline pipeline2 = (TransformationPipeline)some.value();
            TransformationPipelineRunner runner = new TransformationPipelineRunner(handler, configuration);
            baseUnit = runner.run(unit, pipeline2);
        } else if (None$.MODULE$.equals(option)) {
            handler.violation(CoreValidations$.MODULE$.TransformationValidation(), unit.id(), (Option<String>)None$.MODULE$, new StringBuilder(46).append("Cannot find transformation pipeline with name ").append(pipelineName).toString(), unit.position(), unit.location());
            baseUnit = unit;
        } else {
            throw new MatchError(option);
        }
        BaseUnit resolved = baseUnit;
        return new AMFResult(resolved, handler.getResults());
    }

    private AMFTransformer$() {
        MODULE$ = this;
    }
}

