/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.core.keyword.syntax.checkers.common;

import com.github.fge.jackson.NodeType;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.keyword.syntax.checkers.AbstractSyntaxChecker;
import com.github.fge.jsonschema.core.keyword.syntax.checkers.SyntaxChecker;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.core.tree.SchemaTree;
import com.github.fge.jsonschema.core.util.RegexECMA262Helper;
import com.github.fge.msgsimple.bundle.MessageBundle;
import java.util.Collection;

public final class PatternSyntaxChecker
extends AbstractSyntaxChecker {
    private static final SyntaxChecker INSTANCE = new PatternSyntaxChecker();

    public static SyntaxChecker getInstance() {
        return INSTANCE;
    }

    private PatternSyntaxChecker() {
        super("pattern", NodeType.STRING, new NodeType[0]);
    }

    @Override
    protected void checkValue(Collection<JsonPointer> pointers, MessageBundle bundle2, ProcessingReport report, SchemaTree tree) throws ProcessingException {
        String value = this.getNode(tree).textValue();
        if (!RegexECMA262Helper.regexIsValid(value)) {
            report.error(this.newMsg(tree, bundle2, "common.invalidRegex").putArgument("value", value));
        }
    }
}

