/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.core.util;

import javax.annotation.concurrent.ThreadSafe;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;

@ThreadSafe
public final class RegexECMA262Helper {
    private static final String REGEX_IS_VALID_FUNCTION_NAME = "regexIsValid";
    private static final String REG_MATCH_FUNCTION_NAME = "regMatch";
    private static final String jsAsString = "function regexIsValid(re){    try {         new RegExp(re);         return true;    } catch (e) {        return false;    }}function regMatch(re, input){    return new RegExp(re).test(input);}";
    private static final Scriptable SCOPE;
    private static final Function REGEX_IS_VALID;
    private static final Function REG_MATCH;
    private static final Invocable PRIMARY_SCRIPT_ENGINE;

    private RegexECMA262Helper() {
    }

    private static Invocable tryResolvePrimaryEngine() {
        ScriptEngine engine = new ScriptEngineManager().getEngineByName("nashorn");
        if (engine != null) {
            try {
                engine.eval(jsAsString);
                return (Invocable)((Object)engine);
            }
            catch (ScriptException scriptException) {
                // empty catch block
            }
        }
        return null;
    }

    public static boolean regexIsValid(String regex) {
        if (PRIMARY_SCRIPT_ENGINE != null) {
            return RegexECMA262Helper.invokeScriptEngine(REGEX_IS_VALID_FUNCTION_NAME, regex);
        }
        return RegexECMA262Helper.invokeFallbackEngine(REGEX_IS_VALID, regex);
    }

    public static boolean regMatch(String regex, String input) {
        if (PRIMARY_SCRIPT_ENGINE != null) {
            return RegexECMA262Helper.invokeScriptEngine(REG_MATCH_FUNCTION_NAME, regex, input);
        }
        return RegexECMA262Helper.invokeFallbackEngine(REG_MATCH, regex, input);
    }

    private static boolean invokeScriptEngine(String function2, Object ... values) {
        try {
            return (Boolean)PRIMARY_SCRIPT_ENGINE.invokeFunction(function2, values);
        }
        catch (ScriptException e) {
            throw new IllegalStateException("Unexpected error on invoking Script.", e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Unexpected error on invoking Script.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean invokeFallbackEngine(Function function2, Object ... values) {
        Context context = Context.enter();
        try {
            boolean bl = (Boolean)function2.call(context, SCOPE, SCOPE, values);
            return bl;
        }
        finally {
            Context.exit();
        }
    }

    static {
        PRIMARY_SCRIPT_ENGINE = RegexECMA262Helper.tryResolvePrimaryEngine();
        Context ctx = Context.enter();
        try {
            SCOPE = ctx.initStandardObjects(null, false);
            try {
                ctx.evaluateString(SCOPE, jsAsString, "re", 1, null);
            }
            catch (UnsupportedOperationException e) {
                ctx.setOptimizationLevel(-1);
                ctx.evaluateString(SCOPE, jsAsString, "re", 1, null);
            }
            REGEX_IS_VALID = (Function)SCOPE.get(REGEX_IS_VALID_FUNCTION_NAME, SCOPE);
            REG_MATCH = (Function)SCOPE.get(REG_MATCH_FUNCTION_NAME, SCOPE);
        }
        finally {
            Context.exit();
        }
    }
}

