/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.keyword.validator.helpers;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.keyword.validator.helpers.NumericValidator;
import com.github.fge.jsonschema.processors.data.FullData;
import com.github.fge.msgsimple.bundle.MessageBundle;
import java.math.BigDecimal;

public abstract class DivisorValidator
extends NumericValidator {
    protected DivisorValidator(String keyword, JsonNode digest) {
        super(keyword, digest);
    }

    @Override
    protected final void validateLong(ProcessingReport report, MessageBundle bundle2, FullData data) throws ProcessingException {
        long longValue;
        JsonNode node = data.getInstance().getNode();
        long instanceValue = node.longValue();
        long remainder = instanceValue % (longValue = this.number.longValue());
        if (remainder == 0L) {
            return;
        }
        report.error(this.newMsg(data, bundle2, "err.common.divisor.nonZeroRemainder").putArgument("value", node).putArgument("divisor", this.number));
    }

    @Override
    protected final void validateDecimal(ProcessingReport report, MessageBundle bundle2, FullData data) throws ProcessingException {
        BigDecimal decimalValue;
        JsonNode node = data.getInstance().getNode();
        BigDecimal instanceValue = node.decimalValue();
        BigDecimal remainder = instanceValue.remainder(decimalValue = this.number.decimalValue());
        if (remainder.compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        report.error(this.newMsg(data, bundle2, "err.common.divisor.nonZeroRemainder").putArgument("value", node).putArgument("divisor", this.number));
    }
}

