/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.scd;

import java.util.ArrayList;
import java.util.List;
import org.apache.xerces.impl.scd.Axis;
import org.apache.xerces.impl.scd.SCDException;
import org.apache.xerces.impl.scd.Step;
import org.apache.xerces.util.NamespaceSupport;
import org.apache.xerces.util.XML11Char;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;

class SCDParser {
    private List steps = new ArrayList(15);
    private static final int CHARTYPE_AT = 1;
    private static final int CHARTYPE_TILDE = 2;
    private static final int CHARTYPE_PERIOD = 3;
    private static final int CHARTYPE_STAR = 4;
    private static final int CHARTYPE_ZERO = 5;
    private static final int CHARTYPE_1_THROUGH_9 = 6;
    private static final int CHARTYPE_NC_NAMESTART = 7;
    private static final int CHARTYPE_NC_NAME = 8;
    private static final int CHARTYPE_OPEN_BRACKET = 9;
    private static final int CHARTYPE_CLOSE_BRACKET = 10;
    private static final int CHARTYPE_OPEN_PAREN = 11;
    private static final int CHARTYPE_CLOSE_PAREN = 12;
    private static final int CHARTYPE_COLON = 13;
    private static final int CHARTYPE_SLASH = 14;
    private static final int CHARTYPE_NOMORE = 0;
    private static final short LIST_SIZE = 15;
    public static final QName WILDCARD = new QName(null, "*", "*", null);
    public static final QName ZERO = new QName(null, "0", "0", null);

    private static int getCharType(int n) throws SCDException {
        switch (n) {
            case 64: {
                return 1;
            }
            case 126: {
                return 2;
            }
            case 46: {
                return 3;
            }
            case 42: {
                return 4;
            }
            case 58: {
                return 13;
            }
            case 47: {
                return 14;
            }
            case 40: {
                return 11;
            }
            case 41: {
                return 12;
            }
            case 91: {
                return 9;
            }
            case 93: {
                return 10;
            }
            case 48: {
                return 5;
            }
        }
        if (n == 0) {
            return 0;
        }
        if (n >= 49 && n <= 57) {
            return 6;
        }
        if (XML11Char.isXML11NCNameStart(n)) {
            return 7;
        }
        if (XML11Char.isXML11NCName(n)) {
            return 8;
        }
        throw new SCDException("Error in SCP: Unsupported character " + (char)n + " (" + n + ")");
    }

    public static char charAt(String string, int n) {
        if (n >= string.length()) {
            return '\uffff';
        }
        return string.charAt(n);
    }

    private static QName readQName(String string, int[] nArray, int n, NamespaceContext namespaceContext) throws SCDException {
        return SCDParser.readNameTest(string, nArray, n, namespaceContext);
    }

    private static QName readNameTest(String string, int[] nArray, int n, NamespaceContext namespaceContext) throws SCDException {
        int n2 = n;
        int n3 = n;
        String string2 = "";
        String string3 = null;
        if (SCDParser.charAt(string, n) == '*') {
            nArray[0] = n + 1;
            return WILDCARD;
        }
        if (SCDParser.charAt(string, n) == '0') {
            nArray[0] = n + 1;
            return ZERO;
        }
        if (XML11Char.isXML11NCNameStart(SCDParser.charAt(string, n))) {
            while (XML11Char.isXML11NCName(SCDParser.charAt(string, ++n))) {
            }
            string2 = string.substring(n2, n);
            if (SCDParser.charAt(string, n) == ':') {
                if (XML11Char.isXML11NCNameStart(SCDParser.charAt(string, ++n))) {
                    n2 = n;
                    while (XML11Char.isXML11NCName(SCDParser.charAt(string, n++))) {
                    }
                    string3 = string.substring(n2, n - 1);
                }
                if (string3 == null) {
                    string3 = string2;
                    string2 = "";
                }
                nArray[0] = n - 1;
            } else {
                nArray[0] = n;
                string3 = string2;
                string2 = "";
            }
            String string4 = string.substring(n3, nArray[0]);
            if (namespaceContext != null) {
                String string5 = namespaceContext.getURI(string2.intern());
                if ("".equals(string2)) {
                    return new QName(string2, string3, string4, string5);
                }
                if (string5 != null) {
                    return new QName(string2, string3, string4, string5);
                }
                throw new SCDException("Error in SCP: The prefix \"" + string2 + "\" is undeclared in this context");
            }
            throw new SCDException("Error in SCP: Namespace context is null");
        }
        throw new SCDException("Error in SCP: Invalid nametest starting character '" + SCDParser.charAt(string, n) + "'");
    }

    private static int scanNCName(String string, int n) {
        if (XML11Char.isXML11NCNameStart(SCDParser.charAt(string, n))) {
            while (XML11Char.isXML11NCName(SCDParser.charAt(string, ++n))) {
            }
        }
        return n;
    }

    private static int scanXmlnsSchemeData(String string, int n) throws SCDException {
        char c = '\u0000';
        int n2 = 0;
        do {
            if ((c = SCDParser.charAt(string, n)) >= '\u0000' && c <= '\u10ffff') {
                if (c != '^') {
                    ++n;
                    if (c == '(') {
                        ++n2;
                        continue;
                    }
                    if (c != ')') continue;
                    if (--n2 == -1) {
                        return n - 1;
                    }
                    if (SCDParser.charAt(string, n - 2) != '(') continue;
                    throw new SCDException("Error in SCD: empty xmlns scheme data between '(' and ')'");
                }
                if (SCDParser.charAt(string, n + 1) == '(' || SCDParser.charAt(string, n + 1) == ')' || SCDParser.charAt(string, n + 1) == '^') {
                    n += 2;
                    continue;
                }
                throw new SCDException("Error in SCD: '^' character is used as a non escape character at position " + ++n);
            }
            throw new SCDException("Error in SCD: the character '" + c + "' at position " + ++n + " is invalid for xmlns scheme data");
        } while (n < string.length());
        String string2 = "";
        if (n2 != -1) {
            string2 = "Unbalanced parentheses exist within xmlns scheme data section";
        }
        throw new SCDException("Error in SCD: Attempt to read an invalid xmlns Scheme data. " + string2);
    }

    private static int skipWhiteSpaces(String string, int n) {
        while (XML11Char.isXML11Space(SCDParser.charAt(string, n))) {
            ++n;
        }
        return n;
    }

    private static int readPredicate(String string, int[] nArray, int n) throws SCDException {
        int n2 = string.indexOf(93, n);
        if (n2 >= 0) {
            try {
                int n3 = Integer.parseInt(string.substring(n, n2));
                if (n3 > 0) {
                    nArray[0] = n2 + 1;
                    return n3;
                }
                throw new SCDException("Error in SCP: Invalid predicate value " + n3);
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
                throw new SCDException("Error in SCP: A NumberFormatException occurred while reading the predicate");
            }
        }
        throw new SCDException("Error in SCP: Attempt to read an invalid predicate starting from position " + ++n);
    }

    public List parseSCP(String string, NamespaceContext namespaceContext, boolean bl) throws SCDException {
        this.steps.clear();
        if (string.length() == 1 && string.charAt(0) == '/') {
            this.steps.add(new Step(100, null, 0));
            return this.steps;
        }
        if (bl) {
            if ("./".equals(string.substring(0, 2))) {
                string = string.substring(1);
            } else if (string.charAt(0) != '/') {
                string = '/' + string;
            } else {
                throw new SCDException("Error in incomplete SCP: Invalid starting character");
            }
        }
        int n = 0;
        int[] nArray = new int[]{0};
        while (nArray[0] < string.length()) {
            if (SCDParser.charAt(string, nArray[0]) == '/') {
                if (SCDParser.charAt(string, nArray[0] + 1) == '/') {
                    if (nArray[0] + 1 != string.length() - 1) {
                        this.steps.add(new Step(27, WILDCARD, 0));
                        n = nArray[0] + 2;
                    } else {
                        n = nArray[0] + 1;
                    }
                } else {
                    n = nArray[0] != string.length() - 1 ? nArray[0] + 1 : nArray[0];
                }
                Step step = SCDParser.processStep(string, nArray, n, namespaceContext);
                this.steps.add(step);
                continue;
            }
            throw new SCDException("Error in SCP: Invalid character '" + SCDParser.charAt(string, nArray[0]) + " ' at position" + nArray[0]);
        }
        return this.steps;
    }

    private static Step processStep(String string, int[] nArray, int n, NamespaceContext namespaceContext) throws SCDException {
        short s2 = -1;
        QName qName = null;
        int n2 = 0;
        switch (SCDParser.getCharType(SCDParser.charAt(string, n))) {
            case 1: {
                s2 = 0;
                qName = SCDParser.readNameTest(string, nArray, n + 1, namespaceContext);
                break;
            }
            case 2: {
                s2 = 2;
                qName = SCDParser.readNameTest(string, nArray, n + 1, namespaceContext);
                break;
            }
            case 3: {
                s2 = 23;
                qName = WILDCARD;
                nArray[0] = n + 1;
                break;
            }
            case 5: {
                s2 = 1;
                qName = ZERO;
                nArray[0] = n + 1;
                break;
            }
            case 4: {
                s2 = 1;
                qName = WILDCARD;
                nArray[0] = n + 1;
                break;
            }
            case 7: {
                QName qName2 = SCDParser.readQName(string, nArray, n, namespaceContext);
                int n3 = nArray[0];
                if (nArray[0] == string.length()) {
                    s2 = 1;
                    qName = qName2;
                    break;
                }
                if (SCDParser.charAt(string, n3) == ':' && SCDParser.charAt(string, n3 + 1) == ':') {
                    s2 = Axis.qnameToAxis(qName2.rawname);
                    if (s2 == 26) {
                        throw new SCDException("Error in SCP: Extension axis {" + qName2.rawname + "} not supported!");
                    }
                    qName = SCDParser.readNameTest(string, nArray, n3 + 2, namespaceContext);
                    break;
                }
                if (SCDParser.charAt(string, n3) == '(') {
                    throw new SCDException("Error in SCP: Extension accessor not supported!");
                }
                if (SCDParser.charAt(string, n3) == '/') {
                    s2 = 1;
                    qName = qName2;
                    return new Step(s2, qName, n2);
                }
                s2 = 1;
                qName = qName2;
                break;
            }
            default: {
                throw new SCDException("Error in SCP: Invalid character '" + SCDParser.charAt(string, n) + "' at position " + n);
            }
        }
        if (nArray[0] < string.length()) {
            if (SCDParser.charAt(string, nArray[0]) == '[') {
                n2 = SCDParser.readPredicate(string, nArray, nArray[0] + 1);
            } else {
                if (SCDParser.charAt(string, nArray[0]) == '/') {
                    return new Step(s2, qName, n2);
                }
                throw new SCDException("Error in SCP: Unexpected character '" + SCDParser.charAt(string, nArray[0]) + "' at position " + nArray[0]);
            }
        }
        if (SCDParser.charAt(string, nArray[0]) == '/') {
            return new Step(s2, qName, n2);
        }
        if (nArray[0] < string.length()) {
            throw new SCDException("Error in SCP: Unexpected character '" + string.charAt(nArray[0]) + "' at the end");
        }
        return new Step(s2, qName, n2);
    }

    public List parseRelativeSCD(String string, boolean bl) throws SCDException {
        int[] nArray = new int[]{0};
        NamespaceSupport namespaceSupport = new NamespaceSupport();
        while (nArray[0] < string.length()) {
            if ("xmlns".equals(string.substring(nArray[0], nArray[0] + 5))) {
                nArray[0] = SCDParser.readxmlns(string, namespaceSupport, nArray[0] + 5);
                continue;
            }
            if ("xscd".equals(string.substring(nArray[0], nArray[0] + 4))) {
                String string2 = string.substring(nArray[0] + 4, string.length());
                if (SCDParser.charAt(string2, 0) == '(' && SCDParser.charAt(string2, string2.length() - 1) == ')') {
                    return this.parseSCP(string2.substring(1, string2.length() - 1), namespaceSupport, bl);
                }
                nArray[0] = nArray[0] + 1;
                throw new SCDException("Error in SCD: xscd() part is invalid at position " + nArray[0]);
            }
            nArray[0] = nArray[0] + 1;
            throw new SCDException("Error in SCD: Expected 'xmlns' or 'xscd' at position " + nArray[0]);
        }
        nArray[0] = nArray[0] + 1;
        throw new SCDException("Error in SCD: Error at position " + nArray[0]);
    }

    private static int readxmlns(String string, NamespaceContext namespaceContext, int n) throws SCDException {
        if (SCDParser.charAt(string, n++) == '(') {
            int n2 = n;
            if ((n = SCDParser.scanNCName(string, n)) == n2) {
                throw new SCDException("Error in SCD: Missing namespace name at position " + ++n);
            }
            String string2 = string.substring(n2, n);
            if (SCDParser.charAt(string, n = SCDParser.skipWhiteSpaces(string, n)) != '=') {
                throw new SCDException("Error in SCD: Expected a  '=' character at position " + ++n);
            }
            ++n;
            n2 = n = SCDParser.skipWhiteSpaces(string, n);
            if ((n = SCDParser.scanXmlnsSchemeData(string, n)) == n2) {
                throw new SCDException("Error in SCD: Missing namespace value at position " + ++n);
            }
            String string3 = string.substring(n2, n);
            if (SCDParser.charAt(string, n) == ')') {
                namespaceContext.declarePrefix(string2.intern(), string3.intern());
                return ++n;
            }
            throw new SCDException("Error in SCD: Invalid xmlns pointer part at position " + ++n);
        }
        throw new SCDException("Error in SCD: Invalid xmlns pointer part at position " + ++n);
    }
}

