/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xpath;

import org.apache.xerces.impl.dv.xs.TypeValidator;
import org.apache.xerces.impl.dv.xs.XSSimpleTypeDecl;
import org.apache.xerces.xs.ShortList;

class DataMatcher {
    DataMatcher() {
    }

    public static boolean compareActualValues(Object object, Object object2, int n, XSSimpleTypeDecl xSSimpleTypeDecl) {
        TypeValidator typeValidator = xSSimpleTypeDecl.getTypeValidator();
        short s2 = xSSimpleTypeDecl.getOrdered();
        if (s2 == 0) {
            if (n == 0) {
                return xSSimpleTypeDecl.isEqual(object, object2);
            }
            if (n == 1) {
                return !xSSimpleTypeDecl.isEqual(object, object2);
            }
            return false;
        }
        switch (n) {
            case 0: {
                return typeValidator.compare(object, object2) == 0;
            }
            case 1: {
                return typeValidator.compare(object, object2) != 0;
            }
            case 3: {
                return typeValidator.compare(object, object2) > 0;
            }
            case 5: {
                return typeValidator.compare(object, object2) >= 0;
            }
            case 2: {
                return typeValidator.compare(object, object2) < 0;
            }
            case 4: {
                return typeValidator.compare(object, object2) <= 0;
            }
        }
        return false;
    }

    public static boolean isComparable(short s2, short s3, ShortList shortList, ShortList shortList2) {
        short s4;
        short s5 = DataMatcher.convertToPrimitiveKind(s2);
        if (s5 != (s4 = DataMatcher.convertToPrimitiveKind(s3))) {
            return s5 == 1 && s4 == 2 || s5 == 2 && s4 == 1;
        }
        if (s5 == 44 || s5 == 43) {
            int n;
            int n2 = shortList != null ? shortList.getLength() : 0;
            int n3 = n = shortList2 != null ? shortList2.getLength() : 0;
            if (n2 != n) {
                return false;
            }
            for (int i = 0; i < n2; ++i) {
                short s6;
                short s7 = DataMatcher.convertToPrimitiveKind(shortList.item(i));
                if (s7 == (s6 = DataMatcher.convertToPrimitiveKind(shortList2.item(i))) || s7 == 1 && s6 == 2 || s7 == 2 && s6 == 1) continue;
                return false;
            }
        }
        return true;
    }

    private static short convertToPrimitiveKind(short s2) {
        if (s2 <= 20) {
            return s2;
        }
        if (s2 <= 29) {
            return 2;
        }
        if (s2 <= 42) {
            return 4;
        }
        return s2;
    }
}

