/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs;

import java.util.Hashtable;
import java.util.Vector;
import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.XSComplexTypeDecl;
import org.apache.xerces.impl.xs.XSElementDecl;
import org.apache.xerces.impl.xs.XSElementDeclHelper;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSSimpleTypeDefinition;
import org.apache.xerces.xs.XSTypeDefinition;

public class SubstitutionGroupHandler {
    private static final XSElementDecl[] EMPTY_GROUP = new XSElementDecl[0];
    private final XSElementDeclHelper fXSElementDeclHelper;
    Hashtable fSubGroupsB = new Hashtable();
    private static final OneSubGroup[] EMPTY_VECTOR = new OneSubGroup[0];
    Hashtable fSubGroups = new Hashtable();

    public SubstitutionGroupHandler(XSElementDeclHelper xSElementDeclHelper) {
        this.fXSElementDeclHelper = xSElementDeclHelper;
    }

    public XSElementDecl getMatchingElemDecl(QName qName, XSElementDecl xSElementDecl, short s2) {
        if (qName.localpart == xSElementDecl.fName && qName.uri == xSElementDecl.fTargetNamespace) {
            return xSElementDecl;
        }
        if (xSElementDecl.fScope != 1) {
            return null;
        }
        if ((xSElementDecl.fBlock & 4) != 0) {
            return null;
        }
        XSElementDecl xSElementDecl2 = this.fXSElementDeclHelper.getGlobalElementDecl(qName);
        if (xSElementDecl2 == null) {
            return null;
        }
        if (this.substitutionGroupOK(xSElementDecl2, xSElementDecl, xSElementDecl.fBlock, s2)) {
            return xSElementDecl2;
        }
        return null;
    }

    protected boolean substitutionGroupOK(XSElementDecl xSElementDecl, XSElementDecl xSElementDecl2, short s2, short s3) {
        if (xSElementDecl == xSElementDecl2) {
            return true;
        }
        if ((s2 & 4) != 0) {
            return false;
        }
        XSElementDecl[] xSElementDeclArray = xSElementDecl.fSubGroup;
        if (xSElementDeclArray == null || !this.checkSubstitutionGroupAffil(xSElementDeclArray, xSElementDecl2)) {
            return false;
        }
        return this.typeDerivationOK(xSElementDecl.fType, xSElementDecl2.fType, s2, s3);
    }

    private boolean checkSubstitutionGroupAffil(XSElementDecl[] xSElementDeclArray, XSElementDecl xSElementDecl) {
        for (int i = 0; i < xSElementDeclArray.length; ++i) {
            XSElementDecl xSElementDecl2 = xSElementDeclArray[i];
            if (xSElementDecl2 == xSElementDecl) {
                return true;
            }
            if (xSElementDecl2.fSubGroup == null || !this.checkSubstitutionGroupAffil(xSElementDecl2.fSubGroup, xSElementDecl)) continue;
            return true;
        }
        return false;
    }

    private boolean typeDerivationOK(XSTypeDefinition xSTypeDefinition, XSTypeDefinition xSTypeDefinition2, short s2, short s3) {
        short s4 = 0;
        short s5 = s2;
        XSTypeDefinition xSTypeDefinition3 = xSTypeDefinition;
        while (xSTypeDefinition3 != xSTypeDefinition2 && !SchemaGrammar.isAnyType(xSTypeDefinition3)) {
            s4 = xSTypeDefinition3.getTypeCategory() == 15 ? (short)(s4 | ((XSComplexTypeDecl)xSTypeDefinition3).fDerivedBy) : (short)(s4 | 2);
            if ((xSTypeDefinition3 = xSTypeDefinition3.getBaseType()) == null) {
                xSTypeDefinition3 = SchemaGrammar.getXSAnyType(s3);
            }
            if (xSTypeDefinition3.getTypeCategory() != 15) continue;
            s5 = (short)(s5 | ((XSComplexTypeDecl)xSTypeDefinition3).fBlock);
        }
        if (xSTypeDefinition3 != xSTypeDefinition2) {
            XSSimpleTypeDefinition xSSimpleTypeDefinition;
            if (xSTypeDefinition2.getTypeCategory() == 16 && (xSSimpleTypeDefinition = (XSSimpleTypeDefinition)xSTypeDefinition2).getVariety() == 3) {
                XSObjectList xSObjectList = xSSimpleTypeDefinition.getMemberTypes();
                int n = xSObjectList.getLength();
                for (int i = 0; i < n; ++i) {
                    if (!this.typeDerivationOK(xSTypeDefinition, (XSTypeDefinition)xSObjectList.item(i), s2, s3)) continue;
                    return true;
                }
            }
            return false;
        }
        return (s4 & s5) == 0;
    }

    public boolean inSubstitutionGroup(XSElementDecl xSElementDecl, XSElementDecl xSElementDecl2, short s2) {
        return this.substitutionGroupOK(xSElementDecl, xSElementDecl2, xSElementDecl2.fBlock, s2);
    }

    public void reset() {
        this.fSubGroupsB.clear();
        this.fSubGroups.clear();
    }

    public void addSubstitutionGroup(XSElementDecl[] xSElementDeclArray) {
        for (int i = xSElementDeclArray.length - 1; i >= 0; --i) {
            XSElementDecl xSElementDecl = xSElementDeclArray[i];
            XSElementDecl[] xSElementDeclArray2 = xSElementDecl.fSubGroup;
            for (int j = 0; j < xSElementDeclArray2.length; ++j) {
                XSElementDecl xSElementDecl2 = xSElementDeclArray2[j];
                Vector<XSElementDecl> vector = (Vector<XSElementDecl>)this.fSubGroupsB.get(xSElementDecl2);
                if (vector == null) {
                    vector = new Vector<XSElementDecl>();
                    this.fSubGroupsB.put(xSElementDecl2, vector);
                }
                vector.addElement(xSElementDecl);
            }
        }
    }

    public XSElementDecl[] getSubstitutionGroup(XSElementDecl xSElementDecl, short s2) {
        Object v = this.fSubGroups.get(xSElementDecl);
        if (v != null) {
            return (XSElementDecl[])v;
        }
        if ((xSElementDecl.fBlock & 4) != 0) {
            this.fSubGroups.put(xSElementDecl, EMPTY_GROUP);
            return EMPTY_GROUP;
        }
        OneSubGroup[] oneSubGroupArray = this.getSubGroupB(xSElementDecl, new OneSubGroup(), s2);
        int n = oneSubGroupArray.length;
        int n2 = 0;
        XSElementDecl[] xSElementDeclArray = new XSElementDecl[n];
        for (int i = 0; i < n; ++i) {
            if ((xSElementDecl.fBlock & oneSubGroupArray[i].dMethod) != 0) continue;
            xSElementDeclArray[n2++] = oneSubGroupArray[i].sub;
        }
        if (n2 < n) {
            XSElementDecl[] xSElementDeclArray2 = new XSElementDecl[n2];
            System.arraycopy(xSElementDeclArray, 0, xSElementDeclArray2, 0, n2);
            xSElementDeclArray = xSElementDeclArray2;
        }
        this.fSubGroups.put(xSElementDecl, xSElementDeclArray);
        return xSElementDeclArray;
    }

    private OneSubGroup[] getSubGroupB(XSElementDecl xSElementDecl, OneSubGroup oneSubGroup, short s2) {
        int n;
        Object v = this.fSubGroupsB.get(xSElementDecl);
        if (v == null) {
            this.fSubGroupsB.put(xSElementDecl, EMPTY_VECTOR);
            return EMPTY_VECTOR;
        }
        if (v instanceof OneSubGroup[]) {
            return (OneSubGroup[])v;
        }
        Vector vector = (Vector)v;
        Vector<OneSubGroup> vector2 = new Vector<OneSubGroup>();
        for (int i = vector.size() - 1; i >= 0; --i) {
            XSElementDecl xSElementDecl2 = (XSElementDecl)vector.elementAt(i);
            if (!this.getDBMethods(xSElementDecl2.fType, xSElementDecl.fType, oneSubGroup, s2)) continue;
            short s3 = oneSubGroup.dMethod;
            short s4 = oneSubGroup.bMethod;
            vector2.addElement(new OneSubGroup(xSElementDecl2, oneSubGroup.dMethod, oneSubGroup.bMethod));
            OneSubGroup[] oneSubGroupArray = this.getSubGroupB(xSElementDecl2, oneSubGroup, s2);
            for (n = oneSubGroupArray.length - 1; n >= 0; --n) {
                short s5 = (short)(s3 | oneSubGroupArray[n].dMethod);
                short s6 = (short)(s4 | oneSubGroupArray[n].bMethod);
                if ((s5 & s6) != 0) continue;
                vector2.addElement(new OneSubGroup(oneSubGroupArray[n].sub, s5, s6));
            }
        }
        OneSubGroup[] oneSubGroupArray = new OneSubGroup[vector2.size()];
        for (n = vector2.size() - 1; n >= 0; --n) {
            oneSubGroupArray[n] = (OneSubGroup)vector2.elementAt(n);
        }
        this.fSubGroupsB.put(xSElementDecl, oneSubGroupArray);
        return oneSubGroupArray;
    }

    private boolean getDBMethods(XSTypeDefinition xSTypeDefinition, XSTypeDefinition xSTypeDefinition2, OneSubGroup oneSubGroup, short s2) {
        int n = 0;
        short s3 = 0;
        while (xSTypeDefinition != xSTypeDefinition2 && !SchemaGrammar.isAnyType(xSTypeDefinition)) {
            n = xSTypeDefinition.getTypeCategory() == 15 ? (int)((short)(n | ((XSComplexTypeDecl)xSTypeDefinition).fDerivedBy)) : (int)((short)(n | 2));
            if ((xSTypeDefinition = xSTypeDefinition.getBaseType()) == null) {
                xSTypeDefinition = SchemaGrammar.getXSAnyType(s2);
            }
            if (xSTypeDefinition.getTypeCategory() != 15) continue;
            s3 = (short)(s3 | ((XSComplexTypeDecl)xSTypeDefinition).fBlock);
        }
        if (xSTypeDefinition != xSTypeDefinition2 || n & s3) {
            return false;
        }
        oneSubGroup.dMethod = (short)n;
        oneSubGroup.bMethod = s3;
        return true;
    }

    private static final class OneSubGroup {
        XSElementDecl sub;
        short dMethod;
        short bMethod;

        OneSubGroup() {
        }

        OneSubGroup(XSElementDecl xSElementDecl, short s2, short s3) {
            this.sub = xSElementDecl;
            this.dMethod = s2;
            this.bMethod = s3;
        }
    }
}

