/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.traversers;

import java.util.HashMap;
import org.apache.xerces.impl.dv.XSSimpleType;
import org.apache.xerces.impl.xpath.XPath20;
import org.apache.xerces.impl.xpath.XPathException;
import org.apache.xerces.impl.xs.AbstractXPath2EngineImpl;
import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.SchemaNamespaceSupport;
import org.apache.xerces.impl.xs.SchemaSymbols;
import org.apache.xerces.impl.xs.XSAnnotationImpl;
import org.apache.xerces.impl.xs.XSComplexTypeDecl;
import org.apache.xerces.impl.xs.XSElementDecl;
import org.apache.xerces.impl.xs.alternative.Test;
import org.apache.xerces.impl.xs.alternative.XSTypeAlternativeImpl;
import org.apache.xerces.impl.xs.traversers.XSAttributeChecker;
import org.apache.xerces.impl.xs.traversers.XSDAbstractTraverser;
import org.apache.xerces.impl.xs.traversers.XSDHandler;
import org.apache.xerces.impl.xs.traversers.XSDocumentInfo;
import org.apache.xerces.impl.xs.util.XS11TypeHelper;
import org.apache.xerces.impl.xs.util.XSObjectListImpl;
import org.apache.xerces.util.DOMUtil;
import org.apache.xerces.util.NamespaceSupport;
import org.apache.xerces.util.XMLSymbols;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSTypeDefinition;
import org.eclipse.wst.xml.xpath2.processor.JFlexCupParser;
import org.eclipse.wst.xml.xpath2.processor.StaticError;
import org.eclipse.wst.xml.xpath2.processor.StaticNameResolver;
import org.eclipse.wst.xml.xpath2.processor.XPathParserException;
import org.eclipse.wst.xml.xpath2.processor.ast.XPath;
import org.w3c.dom.Element;

class XSDTypeAlternativeTraverser
extends XSDAbstractTraverser {
    private static final XSSimpleType fErrorType;
    private boolean fIsFullXPathModeForCTA;
    private String[] fctaXPathModes = new String[]{"cta-subset", "cta-full"};

    XSDTypeAlternativeTraverser(XSDHandler xSDHandler, XSAttributeChecker xSAttributeChecker) {
        super(xSDHandler, xSAttributeChecker);
        this.fIsFullXPathModeForCTA = xSDHandler.fFullXPathForCTA;
    }

    public void traverse(Element element, XSElementDecl xSElementDecl, XSDocumentInfo xSDocumentInfo, SchemaGrammar schemaGrammar) {
        Object object;
        Object object2;
        Object object3;
        Object[] objectArray = this.fAttrChecker.checkAttributes(element, false, xSDocumentInfo);
        QName qName = (QName)objectArray[XSAttributeChecker.ATTIDX_TYPE];
        String string = (String)objectArray[XSAttributeChecker.ATTIDX_XPATH];
        String string2 = (String)objectArray[XSAttributeChecker.ATTIDX_XPATHDEFAULTNS];
        Element element2 = DOMUtil.getFirstChildElement(element);
        XSAnnotationImpl xSAnnotationImpl = null;
        if (element2 != null && DOMUtil.getLocalName(element2).equals(SchemaSymbols.ELT_ANNOTATION)) {
            xSAnnotationImpl = this.traverseAnnotationDecl(element2, objectArray, false, xSDocumentInfo);
            element2 = DOMUtil.getNextSiblingElement(element2);
        } else {
            object3 = DOMUtil.getSyntheticAnnotation(element);
            if (object3 != null) {
                xSAnnotationImpl = this.traverseSyntheticAnnotation(element, (String)object3, objectArray, false, xSDocumentInfo);
            }
        }
        object3 = null;
        if (xSAnnotationImpl != null) {
            object3 = new XSObjectListImpl();
            ((XSObjectListImpl)object3).addXSObject(xSAnnotationImpl);
        } else {
            object3 = XSObjectListImpl.EMPTY_LIST;
        }
        XSTypeDefinition xSTypeDefinition = null;
        boolean bl = false;
        if (qName != null) {
            xSTypeDefinition = (XSTypeDefinition)this.fSchemaHandler.getGlobalDecl(xSDocumentInfo, 7, qName, element);
        }
        if (element2 != null) {
            object2 = DOMUtil.getLocalName(element2);
            object = null;
            if (((String)object2).equals(SchemaSymbols.ELT_COMPLEXTYPE)) {
                object = this.fSchemaHandler.fComplexTypeTraverser.traverseLocal(element2, xSDocumentInfo, schemaGrammar, xSElementDecl);
                bl = true;
                element2 = DOMUtil.getNextSiblingElement(element2);
            } else if (((String)object2).equals(SchemaSymbols.ELT_SIMPLETYPE)) {
                object = this.fSchemaHandler.fSimpleTypeTraverser.traverseLocal(element2, xSDocumentInfo, schemaGrammar, xSElementDecl);
                bl = true;
                element2 = DOMUtil.getNextSiblingElement(element2);
            }
            if (xSTypeDefinition == null) {
                xSTypeDefinition = object;
            }
            if (bl && qName != null) {
                this.reportSchemaError("src-type-alternative.3.12.13.1", null, element);
            }
        }
        if (qName == null && !bl) {
            this.reportSchemaError("src-type-alternative.3.12.13.2", null, element);
        }
        if (xSTypeDefinition == null) {
            xSTypeDefinition = xSElementDecl.fType;
        } else if (xSTypeDefinition != fErrorType) {
            short s2 = xSElementDecl.fBlock;
            if (xSElementDecl.fType.getTypeCategory() == 15) {
                s2 = (short)(s2 | ((XSComplexTypeDecl)xSElementDecl.fType).getProhibitedSubstitutions());
            }
            if (!this.fSchemaHandler.fXSConstraints.checkTypeDerivationOk(xSTypeDefinition, xSElementDecl.fType, s2)) {
                this.reportSchemaError("e-props-correct.7", new Object[]{xSElementDecl.getName(), XS11TypeHelper.getSchemaTypeName(xSTypeDefinition), XS11TypeHelper.getSchemaTypeName(xSElementDecl.fType)}, element);
                xSTypeDefinition = xSElementDecl.fType;
            }
        }
        if (element2 != null) {
            this.reportSchemaError("s4s-elt-must-match.1", new Object[]{"type alternative", "(annotation?, (simpleType | complexType)?)", DOMUtil.getLocalName(element2)}, element2);
        }
        object2 = new XSTypeAlternativeImpl(xSElementDecl.fName, xSTypeDefinition, (XSObjectList)object3);
        if (string != null) {
            object = null;
            try {
                if (this.fIsFullXPathModeForCTA) {
                    JFlexCupParser jFlexCupParser = new JFlexCupParser();
                    XPath xPath = jFlexCupParser.parse("boolean(" + string + ")", true);
                    HashMap<String, SchemaNamespaceSupport> hashMap = new HashMap<String, SchemaNamespaceSupport>();
                    hashMap.put("XPATH2_NS_CONTEXT", xSDocumentInfo.fNamespaceSupport);
                    AbstractXPath2EngineImpl abstractXPath2EngineImpl = new AbstractXPath2EngineImpl();
                    StaticNameResolver staticNameResolver = new StaticNameResolver(abstractXPath2EngineImpl.initXPath2DynamicContext(null, null, hashMap));
                    staticNameResolver.check(xPath);
                    object = new Test(xPath, string, (XSTypeAlternativeImpl)object2, xSDocumentInfo.fNamespaceSupport);
                } else {
                    object = new Test(new XPath20(string, this.fSymbolTable, new NamespaceSupport(xSDocumentInfo.fNamespaceSupport)), (XSTypeAlternativeImpl)object2, new NamespaceSupport(xSDocumentInfo.fNamespaceSupport));
                }
            }
            catch (XPathException xPathException) {
                object = new Test(null, (XSTypeAlternativeImpl)object2, new NamespaceSupport(xSDocumentInfo.fNamespaceSupport));
                this.reportSchemaError("c-cta-xpath", new Object[]{string, this.fctaXPathModes[0]}, element);
            }
            catch (XPathParserException xPathParserException) {
                object = new Test(null, (XSTypeAlternativeImpl)object2, new NamespaceSupport(xSDocumentInfo.fNamespaceSupport));
                if ("Expression starts with / or //".equals(xPathParserException.getMessage())) {
                    this.fSchemaHandler.reportSchemaWarning("c-cta-xpath-b", new Object[]{string, this.fctaXPathModes[1]}, element);
                } else {
                    this.reportSchemaError("c-cta-xpath", new Object[]{string, this.fctaXPathModes[1]}, element);
                }
            }
            catch (StaticError staticError) {
                object = new Test(null, (XSTypeAlternativeImpl)object2, new NamespaceSupport(xSDocumentInfo.fNamespaceSupport));
                this.reportSchemaError("c-cta-xpath-serr", new Object[]{string, this.fctaXPathModes[1], staticError.code()}, element);
            }
            ((XSTypeAlternativeImpl)object2).setTest((Test)object);
        } else {
            ((XSTypeAlternativeImpl)object2).setNamespaceContext(new NamespaceSupport(xSDocumentInfo.fNamespaceSupport));
        }
        object = this.fSchemaHandler.getDocumentURI(element);
        if (object != null) {
            ((XSTypeAlternativeImpl)object2).setBaseURI((String)object);
        }
        if (string2 == null) {
            if (xSDocumentInfo.fXpathDefaultNamespaceIs2PoundDefault) {
                string2 = xSDocumentInfo.fValidationContext.getURI(XMLSymbols.EMPTY_STRING);
                if (string2 != null) {
                    string2 = this.fSymbolTable.addSymbol(string2);
                }
            } else {
                string2 = xSDocumentInfo.fXpathDefaultNamespace;
            }
        }
        if (string2 != null) {
            ((XSTypeAlternativeImpl)object2).setXPathDefauleNamespace(string2);
        }
        schemaGrammar.addTypeAlternative(xSElementDecl, (XSTypeAlternativeImpl)object2);
        this.fAttrChecker.returnAttrArray(objectArray, xSDocumentInfo);
    }

    static {
        SchemaGrammar schemaGrammar = SchemaGrammar.getS4SGrammar((short)4);
        fErrorType = (XSSimpleType)schemaGrammar.getGlobalTypeDecl("error");
    }
}

