/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.wst.xml.xpath2.api.typesystem.TypeDefinition;
import org.eclipse.wst.xml.xpath2.api.typesystem.TypeModel;
import org.eclipse.wst.xml.xpath2.processor.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.StaticContext;
import org.eclipse.wst.xml.xpath2.processor.function.XSCtrLibrary;
import org.eclipse.wst.xml.xpath2.processor.internal.function.ConstructorFL;
import org.eclipse.wst.xml.xpath2.processor.internal.function.Function;
import org.eclipse.wst.xml.xpath2.processor.internal.function.FunctionLibrary;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyAtomicType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.NodeType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.QName;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSAnyURI;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class DefaultStaticContext
implements StaticContext {
    private boolean _xpath1_compatible = false;
    private String _default_namespace = null;
    private String _default_function_namespace = "http://www.w3.org/2005/xpath-functions";
    private TypeModel _model;
    private XSCtrLibrary builtinTypes;
    private Map<String, String> _namespaces;
    private String _cntxt_item_type;
    private Map<String, org.eclipse.wst.xml.xpath2.api.FunctionLibrary> _functions;
    private XSAnyURI _base_uri;
    private Map<String, List<Document>> _collections;
    private String _default_collection_type;
    private Stack<Map<QName, org.eclipse.wst.xml.xpath2.api.ResultSequence>> _scopes;

    public String get_cntxt_item_type() {
        return this._cntxt_item_type;
    }

    public void set_cntxt_item_type(String cntxtItemType) {
        this._cntxt_item_type = cntxtItemType;
    }

    @Override
    public Map<String, List<Document>> get_collections() {
        return this._collections;
    }

    @Override
    public void set_collections(Map<String, List<Document>> collections) {
        this._collections = collections;
    }

    public String get_default_collection_type() {
        return this._default_collection_type;
    }

    public void set_default_collection_type(String defaultCollectionType) {
        this._default_collection_type = defaultCollectionType;
    }

    public DefaultStaticContext(TypeModel model) {
        this._model = model;
        this.builtinTypes = new XSCtrLibrary();
        this._functions = new HashMap<String, org.eclipse.wst.xml.xpath2.api.FunctionLibrary>(20);
        this._namespaces = new HashMap<String, String>(20);
        this._cntxt_item_type = null;
        this._scopes = new Stack();
        this.new_scope();
        if (this._model != null) {
            this.init_schema(model);
        }
        this._base_uri = new XSAnyURI();
        this.add_namespace("*", "*");
    }

    public DefaultStaticContext() {
        this(null);
    }

    private void init_schema(TypeModel schema) {
        this._model = schema;
    }

    @Override
    public XSAnyURI base_uri() {
        return this._base_uri;
    }

    @Override
    public boolean xpath1_compatible() {
        return this._xpath1_compatible;
    }

    @Override
    public void add_namespace(String prefix, String namespace) {
        if (prefix != null && (prefix.equals("fs") || prefix.equals("op") || prefix.equals("dm"))) {
            return;
        }
        if (prefix == null) {
            this._default_namespace = namespace;
            this._namespaces.put("", namespace);
        } else {
            this._namespaces.put(prefix, namespace);
        }
    }

    @Override
    public String default_namespace() {
        return this._default_namespace;
    }

    @Override
    public String default_function_namespace() {
        return this._default_function_namespace;
    }

    @Override
    public void add_function_library(FunctionLibrary fl) {
        fl.set_static_context(this);
        this._functions.put(fl.namespace(), fl);
    }

    @Override
    public boolean function_exists(QName name, int arity) {
        String ns = name.namespace();
        if (!this._functions.containsKey(ns)) {
            return false;
        }
        FunctionLibrary fl = (FunctionLibrary)this._functions.get(ns);
        return fl.function_exists(name, arity);
    }

    public Function function(QName name, int arity) {
        String ns = name.namespace();
        if (!this._functions.containsKey(ns)) {
            return null;
        }
        FunctionLibrary fl = (FunctionLibrary)this._functions.get(ns);
        return fl.function(name, arity);
    }

    @Override
    public AnyAtomicType make_atomic(QName name) {
        String ns = name.namespace();
        if (!this._functions.containsKey(ns)) {
            return null;
        }
        FunctionLibrary fl = (FunctionLibrary)this._functions.get(ns);
        if (!(fl instanceof ConstructorFL)) {
            return null;
        }
        ConstructorFL cfl = (ConstructorFL)fl;
        return cfl.atomic_type(name);
    }

    private boolean expand_qname(QName name, String def) {
        String prefix = name.prefix();
        if (prefix == null) {
            name.set_namespace(def);
            return true;
        }
        if (!this.prefix_exists(prefix)) {
            return false;
        }
        name.set_namespace(this.resolve_prefix(prefix));
        return true;
    }

    @Override
    public boolean expand_qname(QName name) {
        return this.expand_qname(name, null);
    }

    @Override
    public boolean expand_function_qname(QName name) {
        return this.expand_qname(name, this.default_function_namespace());
    }

    @Override
    public boolean expand_elem_type_qname(QName name) {
        return this.expand_qname(name, this.default_namespace());
    }

    @Override
    public boolean type_defined(QName qname) {
        if (this._model == null) {
            return this.builtinTypes.atomic_type(qname) != null;
        }
        TypeDefinition td = this._model.lookupType(qname.namespace(), qname.local());
        return td != null;
    }

    public boolean type_defined(String ns, String type) {
        return this.type_defined(new QName(ns, type));
    }

    @Override
    public boolean element_declared(QName elem) {
        if (this._model == null) {
            return false;
        }
        TypeDefinition td = this._model.lookupElementDeclaration(elem.local(), elem.namespace());
        return td != null;
    }

    @Override
    public TypeDefinition element_type_definition(QName elem) {
        return this._model.lookupElementDeclaration(elem.local(), elem.namespace());
    }

    @Override
    public boolean attribute_declared(QName attr) {
        if (this._model == null) {
            return false;
        }
        TypeDefinition td = this._model.lookupAttributeDeclaration(attr.local(), attr.namespace());
        return td != null;
    }

    @Override
    public TypeDefinition attribute_type_definition(QName elem) {
        return this._model.lookupAttributeDeclaration(elem.local(), elem.namespace());
    }

    @Override
    public boolean prefix_exists(String pref) {
        return this._namespaces.containsKey(pref);
    }

    @Override
    public String resolve_prefix(String pref) {
        return this._namespaces.get(pref);
    }

    @Override
    public boolean derives_from(NodeType at, QName et) {
        TypeDefinition td = this._model.getType(at.node_value());
        short method = 3;
        if (!et.expanded()) {
            String pre = et.prefix();
            if (pre != null) {
                if (this.prefix_exists(pre)) {
                    et.set_namespace(this.resolve_prefix(pre));
                } else assert (false);
            } else {
                et.set_namespace(this.default_namespace());
            }
        }
        return td != null && td.derivedFrom(et.namespace(), et.local(), method);
    }

    @Override
    public boolean derives_from(NodeType at, TypeDefinition et) {
        TypeDefinition td = this._model.getType(at.node_value());
        short method = 0;
        return td.derivedFromType(et, method);
    }

    @Override
    public void new_scope() {
        HashMap vars = new HashMap();
        this._scopes.push(vars);
    }

    @Override
    public void destroy_scope() {
        this._scopes.pop();
    }

    private Map<QName, org.eclipse.wst.xml.xpath2.api.ResultSequence> current_scope() {
        return this._scopes.peek();
    }

    @Override
    public boolean variable_exists(QName var2) {
        Map<QName, org.eclipse.wst.xml.xpath2.api.ResultSequence> scope = this.current_scope();
        return scope.containsKey(var2);
    }

    @Override
    public boolean variable_in_scope(QName var2) {
        for (Map map : this._scopes) {
            if (!map.containsKey(var2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void add_variable(QName var2) {
        this.set_variable(var2, (AnyType)null);
    }

    protected void set_variable(QName var2, AnyType val2) {
        Map<QName, org.eclipse.wst.xml.xpath2.api.ResultSequence> scope = this.current_scope();
        scope.put(var2, val2);
    }

    protected void set_variable(QName var2, ResultSequence val2) {
        Map<QName, org.eclipse.wst.xml.xpath2.api.ResultSequence> scope = this.current_scope();
        scope.put(var2, val2);
    }

    @Override
    public boolean del_variable(QName var2) {
        if (!this.variable_exists(var2)) {
            return false;
        }
        Map<QName, org.eclipse.wst.xml.xpath2.api.ResultSequence> scope = this.current_scope();
        return scope.remove(var2) != null;
    }

    protected Object get_var(QName var2) {
        int pos = this._scopes.size();
        while (--pos >= 0) {
            Map scope = (Map)this._scopes.get(pos);
            if (!scope.containsKey(var2)) continue;
            return scope.get(var2);
        }
        return null;
    }

    public void debug_print_vars() {
        int level = 0;
        for (Map map : this._scopes) {
            System.out.println("Scope level " + level);
            Iterator j = map.entrySet().iterator();
            while (j.hasNext()) {
                QName varname = (QName)j.next().getKey();
                org.eclipse.wst.xml.xpath2.api.ResultSequence val2 = (org.eclipse.wst.xml.xpath2.api.ResultSequence)map.get(varname);
                String string_val = "null";
                if (val2 instanceof AnyType) {
                    string_val = ((AnyType)val2).getStringValue();
                }
                System.out.println("Varname: " + varname.string() + " expanded=" + varname.expanded() + " Value: " + string_val);
            }
            ++level;
        }
    }

    @Override
    public void set_base_uri(String baseuri) {
        this._base_uri = new XSAnyURI(baseuri);
    }

    @Override
    public TypeModel getTypeModel(Node node) {
        return this._model;
    }

    public Map<String, org.eclipse.wst.xml.xpath2.api.FunctionLibrary> get_function_libraries() {
        return this._functions;
    }
}

