/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.function;

import com.ibm.icu.text.UTF16;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.wst.xml.xpath2.api.EvaluationContext;
import org.eclipse.wst.xml.xpath2.api.Item;
import org.eclipse.wst.xml.xpath2.api.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.internal.SeqType;
import org.eclipse.wst.xml.xpath2.processor.internal.function.Function;
import org.eclipse.wst.xml.xpath2.processor.internal.types.QName;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSInteger;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSString;

public class FnCodepointsToString
extends Function {
    private static Collection<SeqType> _expected_args = null;
    public static final int MIN_LEGAL_CODEPOINT = 1;
    public static final int MAX_LEGAL_CODEPOINT = 0x10FFFF;

    public FnCodepointsToString() {
        super(new QName("codepoints-to-string"), 1);
    }

    @Override
    public ResultSequence evaluate(Collection<ResultSequence> args, EvaluationContext ec) throws DynamicError {
        return FnCodepointsToString.codepoints_to_string(args);
    }

    public static ResultSequence codepoints_to_string(Collection<ResultSequence> args) throws DynamicError {
        Collection<ResultSequence> cargs = Function.convert_arguments(args, FnCodepointsToString.expected_args());
        ResultSequence arg1 = cargs.iterator().next();
        if (arg1.empty()) {
            return new XSString("");
        }
        int[] codePointArray = new int[arg1.size()];
        int codePointIndex = 0;
        Iterator<Item> i = arg1.iterator();
        while (i.hasNext()) {
            XSInteger code = (XSInteger)i.next();
            int codepoint = code.int_value().intValue();
            if (codepoint < 1 || codepoint > 0x10FFFF) {
                throw DynamicError.unsupported_codepoint("U+" + Integer.toString(codepoint, 16).toUpperCase(), null);
            }
            codePointArray[codePointIndex] = codepoint;
            ++codePointIndex;
        }
        try {
            String str = UTF16.newString(codePointArray, 0, codePointArray.length);
            return new XSString(str);
        }
        catch (IllegalArgumentException iae) {
            throw DynamicError.unsupported_codepoint(iae.getMessage(), iae);
        }
    }

    public static synchronized Collection<SeqType> expected_args() {
        if (_expected_args == null) {
            _expected_args = new ArrayList<SeqType>();
            _expected_args.add(new SeqType(new XSInteger(), 1));
        }
        return _expected_args;
    }
}

