/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.types;

import java.math.BigInteger;
import org.eclipse.wst.xml.xpath2.api.Item;
import org.eclipse.wst.xml.xpath2.api.ResultBuffer;
import org.eclipse.wst.xml.xpath2.api.ResultSequence;
import org.eclipse.wst.xml.xpath2.api.typesystem.TypeDefinition;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSInt;
import org.eclipse.wst.xml.xpath2.processor.internal.types.builtin.BuiltinTypeLibrary;

public class XSShort
extends XSInt {
    private static final String XS_SHORT = "xs:short";

    public XSShort() {
        this(BigInteger.valueOf(0L));
    }

    public XSShort(BigInteger x) {
        super(x);
    }

    @Override
    public String string_type() {
        return XS_SHORT;
    }

    @Override
    public String type_name() {
        return "short";
    }

    @Override
    public ResultSequence constructor(ResultSequence arg) throws DynamicError {
        if (arg.empty()) {
            return ResultBuffer.EMPTY;
        }
        Item aat = arg.first();
        try {
            BigInteger bigInt = new BigInteger(aat.getStringValue());
            BigInteger min2 = BigInteger.valueOf(-32768L);
            BigInteger max = BigInteger.valueOf(32767L);
            if (bigInt.compareTo(min2) < 0 || bigInt.compareTo(max) > 0) {
                DynamicError.throw_type_error();
            }
            return new XSShort(bigInt);
        }
        catch (NumberFormatException e) {
            throw DynamicError.cant_cast(null, e);
        }
    }

    @Override
    public TypeDefinition getTypeDefinition() {
        return BuiltinTypeLibrary.XS_SHORT;
    }

    @Override
    public Short getNativeValue() {
        return this.getValue().shortValue();
    }
}

