/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.utils;

import com.ibm.icu.lang.UCharacter;
import org.eclipse.wst.xml.xpath2.processor.internal.utils.CodePointIterator;

public final class StringCodePointIterator
implements CodePointIterator {
    private String text;
    private int end;
    private int pos;
    private int cpPos;

    public StringCodePointIterator(String text) {
        if (text == null) {
            throw new NullPointerException();
        }
        this.text = text;
        this.end = text.length();
        if (this.end > 0 && UCharacter.isHighSurrogate((char)text.charAt(this.end - 1))) {
            throw new IllegalArgumentException("Invalid UTF-16 sequence ending with a high surrogate");
        }
        this.pos = 0;
        this.cpPos = 0;
    }

    public void setText(String text) {
        if (text == null) {
            throw new NullPointerException();
        }
        this.text = text;
        this.end = text.length();
        this.pos = 0;
        this.cpPos = 0;
    }

    @Override
    public int first() {
        this.pos = 0;
        this.cpPos = 0;
        return this.current();
    }

    @Override
    public int last() {
        this.pos = this.end;
        this.cpPos = UCharacter.codePointCount(this.text, 0, this.pos);
        return this.previous();
    }

    @Override
    public int current() {
        if (this.pos < this.end) {
            char ch1 = this.text.charAt(this.pos);
            if (UCharacter.isHighSurrogate((char)ch1)) {
                return UCharacter.toCodePoint((char)ch1, (char)this.text.charAt(this.pos + 1));
            }
            return ch1;
        }
        return -1;
    }

    @Override
    public int next() {
        if (this.pos < this.end - 1) {
            ++this.pos;
            if (UCharacter.isLowSurrogate((char)this.text.charAt(this.pos))) {
                ++this.pos;
            }
            ++this.cpPos;
            return this.current();
        }
        this.pos = this.end;
        return -1;
    }

    @Override
    public int previous() {
        if (this.pos > 0) {
            --this.pos;
            if (UCharacter.isLowSurrogate((char)this.text.charAt(this.pos))) {
                --this.pos;
            }
            --this.cpPos;
            return this.current();
        }
        return -1;
    }

    @Override
    public int getIndex() {
        return this.cpPos;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof StringCodePointIterator)) {
            return false;
        }
        StringCodePointIterator that = (StringCodePointIterator)obj;
        if (this.hashCode() != that.hashCode()) {
            return false;
        }
        if (!this.text.equals(that.text)) {
            return false;
        }
        return this.pos == that.pos && this.end == that.end;
    }

    public int hashCode() {
        return this.text.hashCode() ^ this.pos ^ this.end;
    }

    @Override
    public Object clone() {
        try {
            StringCodePointIterator other = (StringCodePointIterator)super.clone();
            return other;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }
}

