/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.everit.json.schema.ArraySchema;
import org.everit.json.schema.BooleanSchema;
import org.everit.json.schema.CombinedSchema;
import org.everit.json.schema.ConditionalSchema;
import org.everit.json.schema.ConstSchema;
import org.everit.json.schema.EmptySchema;
import org.everit.json.schema.EnumSchema;
import org.everit.json.schema.FalseSchema;
import org.everit.json.schema.FormatValidator;
import org.everit.json.schema.NotSchema;
import org.everit.json.schema.NullSchema;
import org.everit.json.schema.NumberSchema;
import org.everit.json.schema.ObjectSchema;
import org.everit.json.schema.ReferenceSchema;
import org.everit.json.schema.Schema;
import org.everit.json.schema.StringSchema;
import org.everit.json.schema.TrueSchema;
import org.everit.json.schema.Visitor;
import org.everit.json.schema.internal.JSONPrinter;
import org.everit.json.schema.loader.SpecificationVersion;
import org.everit.json.schema.regexp.Regexp;
import org.json.JSONException;

class ToStringVisitor
extends Visitor {
    private final JSONPrinter writer;
    private boolean jsonObjectIsOpenForCurrentSchemaInstance = false;
    private boolean skipNextObject = false;
    private SpecificationVersion deducedSpecVersion;

    ToStringVisitor(JSONPrinter writer) {
        this.writer = writer;
    }

    @Override
    void visitSchema(Schema schema) {
        if (schema == null) {
            return;
        }
        if (!this.jsonObjectIsOpenForCurrentSchemaInstance) {
            this.writer.object();
        }
        this.writer.ifPresent("title", schema.getTitle());
        this.writer.ifPresent("description", schema.getDescription());
        this.writer.ifPresent("nullable", schema.isNullable());
        this.writer.ifPresent("default", schema.getDefaultValue());
        this.writer.ifPresent("readOnly", schema.isReadOnly());
        this.writer.ifPresent("writeOnly", schema.isWriteOnly());
        super.visitSchema(schema);
        Object schemaKeywordValue = schema.getUnprocessedProperties().get("$schema");
        String idKeyword = this.deduceSpecVersion(schemaKeywordValue).idKeyword();
        this.writer.ifPresent(idKeyword, schema.getId());
        schema.getUnprocessedProperties().forEach((key, val2) -> this.writer.key((String)key).value(val2));
        schema.describePropertiesTo(this.writer);
        if (!this.jsonObjectIsOpenForCurrentSchemaInstance) {
            this.writer.endObject();
        }
    }

    private SpecificationVersion deduceSpecVersion(Object schemaKeywordValue) {
        if (this.deducedSpecVersion != null) {
            return this.deducedSpecVersion;
        }
        if (schemaKeywordValue instanceof String) {
            this.deducedSpecVersion = SpecificationVersion.lookupByMetaSchemaUrl((String)schemaKeywordValue).orElse(SpecificationVersion.DRAFT_4);
            return this.deducedSpecVersion;
        }
        this.deducedSpecVersion = SpecificationVersion.DRAFT_4;
        return this.deducedSpecVersion;
    }

    private void printInJsonObject(Runnable task) {
        if (this.skipNextObject) {
            this.skipNextObject = false;
            this.jsonObjectIsOpenForCurrentSchemaInstance = true;
            task.run();
            this.jsonObjectIsOpenForCurrentSchemaInstance = false;
        } else {
            this.writer.object();
            this.jsonObjectIsOpenForCurrentSchemaInstance = true;
            task.run();
            this.writer.endObject();
            this.jsonObjectIsOpenForCurrentSchemaInstance = false;
        }
    }

    @Override
    void visitBooleanSchema(BooleanSchema schema) {
        this.printInJsonObject(() -> {
            super.visitBooleanSchema(schema);
            this.writer.key("type").value("boolean");
        });
    }

    @Override
    void visitArraySchema(ArraySchema schema) {
        this.printInJsonObject(() -> {
            if (schema.requiresArray()) {
                this.writer.key("type").value("array");
            }
            this.writer.ifTrue("uniqueItems", schema.needsUniqueItems()).ifPresent("minItems", schema.getMinItems()).ifPresent("maxItems", schema.getMaxItems()).ifFalse("additionalItems", schema.permitsAdditionalItems());
            super.visitArraySchema(schema);
        });
    }

    @Override
    void visit(Schema schema) {
        boolean orig = this.jsonObjectIsOpenForCurrentSchemaInstance;
        this.jsonObjectIsOpenForCurrentSchemaInstance = false;
        super.visit(schema);
        this.jsonObjectIsOpenForCurrentSchemaInstance = orig;
    }

    @Override
    void visitAllItemSchema(Schema allItemSchema) {
        this.writer.key("items");
        this.visit(allItemSchema);
    }

    @Override
    void visitEmptySchema(EmptySchema emptySchema) {
        if (emptySchema instanceof TrueSchema) {
            this.writer.value(true);
        } else {
            this.printInJsonObject(() -> super.visitEmptySchema(emptySchema));
        }
    }

    @Override
    void visitItemSchemas(List<Schema> itemSchemas) {
        this.writer.key("items");
        this.writer.array();
        super.visitItemSchemas(itemSchemas);
        this.writer.endArray();
    }

    @Override
    void visitItemSchema(int index, Schema itemSchema) {
        this.visit(itemSchema);
    }

    @Override
    void visitSchemaOfAdditionalItems(Schema schemaOfAdditionalItems) {
        this.writer.key("additionalItems");
        this.visit(schemaOfAdditionalItems);
    }

    @Override
    void visitContainedItemSchema(Schema containedItemSchema) {
        this.writer.key("contains");
        this.visit(containedItemSchema);
    }

    @Override
    void visitConditionalSchema(ConditionalSchema conditionalSchema) {
        this.printInJsonObject(() -> super.visitConditionalSchema(conditionalSchema));
    }

    @Override
    void visitNotSchema(NotSchema notSchema) {
        this.printInJsonObject(() -> {
            this.visitSchema(notSchema);
            this.writer.key("not");
            notSchema.getMustNotMatch().accept(this);
        });
    }

    @Override
    void visitNumberSchema(NumberSchema schema) {
        this.printInJsonObject(() -> {
            if (schema.requiresInteger()) {
                this.writer.key("type").value("integer");
            } else if (schema.isRequiresNumber()) {
                this.writer.key("type").value("number");
            }
            this.writer.ifPresent("minimum", schema.getMinimum());
            this.writer.ifPresent("maximum", schema.getMaximum());
            this.writer.ifPresent("multipleOf", schema.getMultipleOf());
            this.writer.ifTrue("exclusiveMinimum", schema.isExclusiveMinimum());
            this.writer.ifTrue("exclusiveMaximum", schema.isExclusiveMaximum());
            try {
                this.writer.ifPresent("exclusiveMinimum", schema.getExclusiveMinimumLimit());
                this.writer.ifPresent("exclusiveMaximum", schema.getExclusiveMaximumLimit());
            }
            catch (JSONException e) {
                throw new IllegalStateException("overloaded use of exclusiveMinimum or exclusiveMaximum keyword");
            }
            super.visitNumberSchema(schema);
        });
    }

    @Override
    void visitConstSchema(ConstSchema constSchema) {
        this.printInJsonObject(() -> {
            this.writer.key("const");
            this.writer.value(constSchema.getPermittedValue());
            super.visitConstSchema(constSchema);
        });
    }

    @Override
    void visitObjectSchema(ObjectSchema schema) {
        this.printInJsonObject(() -> {
            if (schema.requiresObject()) {
                this.writer.key("type").value("object");
            }
            this.writer.ifPresent("minProperties", schema.getMinProperties());
            this.writer.ifPresent("maxProperties", schema.getMaxProperties());
            if (!schema.getPropertyDependencies().isEmpty()) {
                this.describePropertyDependencies(schema.getPropertyDependencies());
            }
            if (!schema.getSchemaDependencies().isEmpty()) {
                this.writer.key("dependencies");
                this.printSchemaMap(schema.getSchemaDependencies());
            }
            this.writer.ifFalse("additionalProperties", schema.permitsAdditionalProperties());
            super.visitObjectSchema(schema);
        });
    }

    @Override
    void visitRequiredProperties(List<String> requiredProperties) {
        if (!requiredProperties.isEmpty()) {
            this.writer.key("required").value(requiredProperties);
        }
    }

    @Override
    void visitSchemaOfAdditionalProperties(Schema schemaOfAdditionalProperties) {
        this.writer.key("additionalProperties");
        this.visit(schemaOfAdditionalProperties);
    }

    private void describePropertyDependencies(Map<String, Set<String>> propertyDependencies) {
        this.writer.key("dependencies");
        this.writer.object();
        propertyDependencies.forEach((key, value) -> {
            this.writer.key((String)key);
            this.writer.array();
            value.forEach(this.writer::value);
            this.writer.endArray();
        });
        this.writer.endObject();
    }

    @Override
    void visitPropertyNameSchema(Schema propertyNameSchema) {
        this.writer.key("propertyNames");
        this.visit(propertyNameSchema);
    }

    @Override
    void visitPropertySchemas(Map<String, Schema> propertySchemas) {
        if (!propertySchemas.isEmpty()) {
            this.writer.key("properties");
            this.printSchemaMap(propertySchemas);
        }
    }

    private void printSchemaMap(Map<?, Schema> schemas) {
        this.writer.object();
        schemas.forEach((key, value) -> {
            this.writer.key(key.toString());
            this.visit((Schema)value);
        });
        this.writer.endObject();
    }

    @Override
    void visitPatternProperties(Map<Regexp, Schema> patternProperties) {
        if (!patternProperties.isEmpty()) {
            this.writer.key("patternProperties");
            this.printSchemaMap(patternProperties);
        }
    }

    @Override
    void visitCombinedSchema(CombinedSchema combinedSchema) {
        this.printInJsonObject(() -> {
            super.visitCombinedSchema(combinedSchema);
            if (combinedSchema.isSynthetic()) {
                combinedSchema.getSubschemas().forEach(subschema -> {
                    this.skipNextObject = true;
                    super.visit((Schema)subschema);
                });
            } else {
                this.writer.key(combinedSchema.getCriterion().toString());
                this.writer.array();
                combinedSchema.getSubschemas().forEach(subschema -> subschema.accept(this));
                this.writer.endArray();
            }
        });
    }

    @Override
    void visitIfSchema(Schema ifSchema) {
        this.writer.key("if");
        this.visit(ifSchema);
    }

    @Override
    void visitThenSchema(Schema thenSchema) {
        this.writer.key("then");
        this.visit(thenSchema);
    }

    @Override
    void visitElseSchema(Schema elseSchema) {
        this.writer.key("else");
        this.visit(elseSchema);
    }

    @Override
    void visitFalseSchema(FalseSchema falseSchema) {
        this.writer.value(false);
    }

    @Override
    void visitNullSchema(NullSchema nullSchema) {
        this.printInJsonObject(() -> {
            this.writer.key("type");
            this.writer.value("null");
            super.visitNullSchema(nullSchema);
        });
    }

    @Override
    void visitStringSchema(StringSchema schema) {
        this.printInJsonObject(() -> {
            if (schema.requireString()) {
                this.writer.key("type").value("string");
            }
            this.writer.ifPresent("minLength", schema.getMinLength());
            this.writer.ifPresent("maxLength", schema.getMaxLength());
            this.writer.ifPresent("pattern", schema.getPattern());
            if (schema.getFormatValidator() != null && !FormatValidator.NONE.equals(schema.getFormatValidator())) {
                this.writer.key("format").value(schema.getFormatValidator().formatName());
            }
            super.visitStringSchema(schema);
        });
    }

    @Override
    void visitEnumSchema(EnumSchema schema) {
        this.printInJsonObject(() -> {
            this.writer.key("enum");
            this.writer.array();
            schema.getPossibleValues().forEach(this.writer::value);
            this.writer.endArray();
            super.visitEnumSchema(schema);
        });
    }

    @Override
    void visitReferenceSchema(ReferenceSchema referenceSchema) {
        this.printInJsonObject(() -> {
            this.writer.key("$ref");
            this.writer.value(referenceSchema.getReferenceValue());
            super.visitReferenceSchema(referenceSchema);
        });
    }
}

