/*
 * Decompiled with CFR 0.152.
 */
package org.mule.amf.impl.parser.rule;

import amf.core.client.platform.validation.AMFValidationResult;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.apikit.validation.ApiValidationResult;
import org.mule.apikit.validation.Severity;
import org.mulesoft.common.client.lexical.Position;
import org.mulesoft.common.client.lexical.PositionRange;

public class ApiValidationResultImpl
implements ApiValidationResult {
    private static final String ERROR_FORMAT = "%s\n  Location: %s\n  Position: %s";
    private static final String POSITION_FORMAT = "Line %s,  Column %s";
    private AMFValidationResult validationResult;
    private List<String> severities;

    public ApiValidationResultImpl(AMFValidationResult validationResult) {
        this.validationResult = validationResult;
        this.severities = Arrays.stream(Severity.values()).map(Enum::name).collect(Collectors.toList());
    }

    @Override
    public String getMessage() {
        Optional<String> location = this.validationResult.location();
        PositionRange positionRange = this.validationResult.position();
        if (location.isPresent() && !positionRange.start().isZero()) {
            return String.format(ERROR_FORMAT, this.validationResult.message(), URLDecoder.decode(location.get()), ApiValidationResultImpl.getPositionMessage(positionRange.start()));
        }
        return this.validationResult.message();
    }

    @Override
    public Optional<Integer> getLine() {
        return Optional.empty();
    }

    @Override
    public String getPath() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Severity getSeverity() {
        return !this.severities.contains(this.validationResult.severityLevel().toUpperCase()) ? Severity.ERROR : Severity.fromString(this.validationResult.severityLevel());
    }

    private static String getPositionMessage(Position startPosition) {
        return String.format(POSITION_FORMAT, startPosition.line(), startPosition.column());
    }

    public String toString() {
        return this.getMessage();
    }
}

