/*
 * Decompiled with CFR 0.152.
 */
package org.mule.apikit.implv1.model;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.mule.apikit.ParserUtils;
import org.mule.apikit.implv1.model.ActionImpl;
import org.mule.apikit.implv1.model.parameter.ParameterImpl;
import org.mule.apikit.model.Action;
import org.mule.apikit.model.parameter.Parameter;
import org.raml.model.ActionType;
import org.raml.model.Resource;
import org.raml.model.parameter.UriParameter;

public class ResourceImpl
implements org.mule.apikit.model.Resource {
    private static final String VERSION = "version";
    Resource resource;

    public ResourceImpl(Resource resource) {
        this.resource = resource;
    }

    @Override
    public Action getAction(String s2) {
        org.raml.model.Action action = this.resource.getAction(s2);
        if (action == null) {
            return null;
        }
        return new ActionImpl(action);
    }

    @Override
    public String getUri() {
        return this.resource.getUri();
    }

    @Override
    public String getResolvedUri(String version2) {
        return ParserUtils.resolveVersion(this.getUri(), version2);
    }

    @Override
    public void setParentUri(String s2) {
        this.resource.setParentUri(s2);
    }

    @Override
    public Map<String, org.mule.apikit.model.Resource> getResources() {
        if (this.resource.getResources() == null) {
            return null;
        }
        LinkedHashMap<String, org.mule.apikit.model.Resource> map = new LinkedHashMap<String, org.mule.apikit.model.Resource>();
        for (Map.Entry<String, Resource> entry : this.resource.getResources().entrySet()) {
            map.put(entry.getKey(), new ResourceImpl(entry.getValue()));
        }
        return map;
    }

    @Override
    public String getParentUri() {
        return this.resource.getParentUri();
    }

    @Override
    public Map<org.mule.apikit.model.ActionType, Action> getActions() {
        if (this.resource.getActions() == null) {
            return null;
        }
        LinkedHashMap<org.mule.apikit.model.ActionType, Action> map = new LinkedHashMap<org.mule.apikit.model.ActionType, Action>();
        for (Map.Entry<ActionType, org.raml.model.Action> entry : this.resource.getActions().entrySet()) {
            map.put(org.mule.apikit.model.ActionType.valueOf(entry.getKey().name()), new ActionImpl(entry.getValue()));
        }
        return map;
    }

    @Override
    public Map<String, List<Parameter>> getBaseUriParameters() {
        if (this.resource.getBaseUriParameters() == null) {
            return null;
        }
        LinkedHashMap<String, List<Parameter>> map = new LinkedHashMap<String, List<Parameter>>();
        for (Map.Entry<String, List<UriParameter>> entry : this.resource.getBaseUriParameters().entrySet()) {
            ArrayList<ParameterImpl> list = new ArrayList<ParameterImpl>();
            for (UriParameter parameter : entry.getValue()) {
                list.add(new ParameterImpl(parameter));
            }
            map.put(entry.getKey(), list);
        }
        return map;
    }

    @Override
    public Map<String, Parameter> getResolvedUriParameters() {
        return ResourceImpl.loadResolvedUriParameters(this.resource);
    }

    static Map<String, Parameter> loadResolvedUriParameters(Resource resource) {
        if (resource.getResolvedUriParameters() == null) {
            return null;
        }
        LinkedHashMap<String, Parameter> map = new LinkedHashMap<String, Parameter>();
        for (Map.Entry<String, UriParameter> entry : resource.getResolvedUriParameters().entrySet()) {
            if (VERSION.equals(entry.getKey())) continue;
            map.put(entry.getKey(), new ParameterImpl(entry.getValue()));
        }
        Map<String, List<UriParameter>> baseUriParameters = resource.getBaseUriParameters();
        if (MapUtils.isNotEmpty(baseUriParameters)) {
            for (Map.Entry<String, List<UriParameter>> entry : baseUriParameters.entrySet()) {
                map.put(entry.getKey(), new ParameterImpl(entry.getValue().get(0)));
            }
        }
        return map;
    }

    @Override
    public String getDisplayName() {
        return this.resource.getDisplayName();
    }

    @Override
    public String getRelativeUri() {
        return this.resource.getRelativeUri();
    }

    @Override
    public void cleanBaseUriParameters() {
        this.resource.getBaseUriParameters().clear();
    }

    public String toString() {
        return this.getUri();
    }
}

