/*
 * Decompiled with CFR 0.152.
 */
package org.mule.apikit.implv2;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.mule.apikit.ApiParser;
import org.mule.apikit.common.ApiSyncUtils;
import org.mule.apikit.implv2.loader.ApiSyncResourceLoader;
import org.mule.apikit.implv2.loader.ExchangeDependencyResourceLoader;
import org.mule.apikit.implv2.parser.rule.ApiValidationResultImpl;
import org.mule.apikit.implv2.v10.model.RamlImpl10V2;
import org.mule.apikit.model.ApiSpecification;
import org.mule.apikit.validation.ApiValidationReport;
import org.mule.apikit.validation.ApiValidationResult;
import org.mule.apikit.validation.DefaultApiValidationReport;
import org.raml.v2.api.RamlModelBuilder;
import org.raml.v2.api.RamlModelResult;
import org.raml.v2.api.loader.CompositeResourceLoader;
import org.raml.v2.api.loader.DefaultResourceLoader;
import org.raml.v2.api.loader.FileResourceLoader;
import org.raml.v2.api.loader.ResourceLoader;
import org.raml.v2.api.loader.RootRamlFileResourceLoader;
import org.raml.v2.api.model.common.ValidationResult;

public class ParserWrapperV2
implements ApiParser {
    private static final ResourceLoader DEFAULT_RESOURCE_LOADER = new DefaultResourceLoader();
    private final String ramlPath;
    private final ResourceLoader resourceLoader;
    private final List<String> references;
    private final String originalPath;

    public ParserWrapperV2(String ramlPath, List<String> references) {
        this(ramlPath, Collections.emptyList(), references);
    }

    public ParserWrapperV2(String ramlPath, List<ResourceLoader> resourceLoader, List<String> references) {
        this.ramlPath = ParserWrapperV2.fetchRamlResource(ramlPath).map(File::getPath).orElse(ramlPath);
        this.references = references;
        ImmutableCollection loaders = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add(ParserWrapperV2.getResourceLoaderForPath(this.ramlPath))).addAll(resourceLoader)).build();
        this.resourceLoader = new CompositeResourceLoader(loaders.toArray(new ResourceLoader[0]));
        this.originalPath = ramlPath;
    }

    public static ResourceLoader getResourceLoaderForPath(String ramlPath) {
        if (ApiSyncUtils.isSyncProtocol(ramlPath)) {
            return new ApiSyncResourceLoader(ramlPath);
        }
        File ramlFolder = ParserWrapperV2.fetchRamlFolder(ramlPath);
        if (ramlFolder != null) {
            return new CompositeResourceLoader(new RootRamlFileResourceLoader(ramlFolder), DEFAULT_RESOURCE_LOADER, new FileResourceLoader(ramlFolder.getAbsolutePath()), new ExchangeDependencyResourceLoader(ramlFolder));
        }
        return new CompositeResourceLoader(DEFAULT_RESOURCE_LOADER, new ExchangeDependencyResourceLoader());
    }

    private static File fetchRamlFolder(String ramlPath) {
        Supplier<File> fileSupplier = () -> {
            File file = new File(ramlPath);
            return file.exists() && file.getParent() != null ? file.getParentFile() : null;
        };
        return StringUtils.isBlank(ramlPath) ? null : ParserWrapperV2.fetchRamlResource(ramlPath).orElseGet(fileSupplier);
    }

    private static Optional<File> fetchRamlResource(String ramlPath) {
        if (StringUtils.isNotBlank(ramlPath) && !ApiSyncUtils.isSyncProtocol(ramlPath)) {
            try {
                URL url = Thread.currentThread().getContextClassLoader().getResource(ramlPath);
                if (url != null && "file".equals(url.getProtocol())) {
                    return Optional.of(Paths.get(url.toURI()).toFile());
                }
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        return Optional.empty();
    }

    @Override
    public ApiValidationReport validate() {
        List<ApiValidationResult> results = this.validate(this.resourceLoader, this.ramlPath);
        return new DefaultApiValidationReport(results);
    }

    private List<ApiValidationResult> validate(ResourceLoader resourceLoader, String ramlPath) {
        ArrayList<ApiValidationResult> result = new ArrayList<ApiValidationResult>();
        try {
            RamlModelResult ramlApiResult = new RamlModelBuilder(resourceLoader).buildApi((String)null, ramlPath);
            for (ValidationResult validationResult : ramlApiResult.getValidationResults()) {
                result.add(new ApiValidationResultImpl(validationResult));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Raml parser uncaught exception: " + e.getMessage(), e);
        }
        return result;
    }

    @Override
    public ApiSpecification parse() {
        RamlModelResult ramlModelResult = new RamlModelBuilder(this.resourceLoader).buildApi(this.ramlPath);
        if (ramlModelResult.hasErrors()) {
            throw new RuntimeException("Invalid RAML descriptor.");
        }
        return new RamlImpl10V2(ramlModelResult.getApiV10(), this.resourceLoader, this.originalPath, this.references);
    }
}

