/*
 * Decompiled with CFR 0.152.
 */
package org.mule.apikit.implv2.loader;

import com.google.common.base.Strings;
import java.io.File;
import java.io.InputStream;
import java.util.regex.Matcher;
import javax.annotation.Nullable;
import org.mule.apikit.implv2.utils.ExchangeDependencyUtils;
import org.raml.v2.api.loader.DefaultResourceLoader;
import org.raml.v2.api.loader.ResourceLoader;

public class ExchangeDependencyResourceLoader
implements ResourceLoader {
    private final File workingFolder;
    private final ResourceLoader resourceLoader = new DefaultResourceLoader();

    public ExchangeDependencyResourceLoader() {
        this(null);
    }

    public ExchangeDependencyResourceLoader(File workingFolder) {
        this.workingFolder = workingFolder;
    }

    @Override
    @Nullable
    public InputStream fetchResource(String path) {
        if (Strings.isNullOrEmpty(path)) {
            return null;
        }
        if (this.workingFolder != null) {
            int dependencyIndex;
            Matcher matcher = ExchangeDependencyUtils.DEPENDENCY_PATH_PATTERN.matcher(path);
            String resourceName = matcher.find() ? ((dependencyIndex = path.lastIndexOf(matcher.group(0))) <= 0 ? path : path.substring(dependencyIndex)) : path;
            return this.resourceLoader.fetchResource(new File(this.workingFolder, resourceName).getPath());
        }
        return this.resourceLoader.fetchResource(ExchangeDependencyUtils.getExchangeModulePath(path));
    }
}

