/*
 * Decompiled with CFR 0.152.
 */
package org.mule.apikit.implv2.v10;

import com.google.common.base.Strings;
import java.util.Optional;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.json.api.JsonTypeLoader;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;

public class MetadataResolver {
    private static final MetadataType ANY_METADATA_TYPE = BaseTypeBuilder.create(MetadataFormat.JAVA).anyType().build();

    private MetadataResolver() {
    }

    public static Optional<MetadataType> resolve(TypeDeclaration type) {
        String schema = type.toJsonSchema();
        return Strings.isNullOrEmpty(schema) ? Optional.of(MetadataResolver.anyType()) : MetadataResolver.fromJsonSchema(schema);
    }

    private static Optional<MetadataType> fromJsonSchema(String jsonSchema) {
        JsonTypeLoader jsonTypeLoader = new JsonTypeLoader(jsonSchema);
        return jsonTypeLoader.load(null);
    }

    public static MetadataType anyType() {
        return ANY_METADATA_TYPE;
    }
}

