/*
 * Decompiled with CFR 0.152.
 */
package org.mule.apikit.implv2.v10.model;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.mule.apikit.implv2.v10.model.MimeTypeImpl;
import org.mule.apikit.implv2.v10.model.ParameterImpl;
import org.mule.apikit.implv2.v10.model.QueryStringImpl;
import org.mule.apikit.implv2.v10.model.ResourceImpl;
import org.mule.apikit.implv2.v10.model.ResponseImpl;
import org.mule.apikit.model.Action;
import org.mule.apikit.model.ActionType;
import org.mule.apikit.model.MimeType;
import org.mule.apikit.model.QueryString;
import org.mule.apikit.model.Resource;
import org.mule.apikit.model.SecurityReference;
import org.mule.apikit.model.parameter.Parameter;
import org.raml.v2.api.model.v10.bodies.Response;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;
import org.raml.v2.api.model.v10.methods.Method;

public class ActionImpl
implements Action {
    private Method method;
    private Map<String, MimeType> bodies;
    private Map<String, org.mule.apikit.model.Response> responses;
    private Map<String, Parameter> queryParameters;
    private Map<String, Parameter> headers;
    private Map<String, Parameter> resolvedUriParameters;
    private String successStatusCode;

    public ActionImpl(Method method) {
        this.method = method;
    }

    @Override
    public ActionType getType() {
        return ActionType.valueOf(this.method.method().toUpperCase());
    }

    @Override
    public boolean hasBody() {
        return !this.getBody().isEmpty();
    }

    @Override
    public Map<String, org.mule.apikit.model.Response> getResponses() {
        if (this.responses == null) {
            this.responses = ActionImpl.loadResponses(this.method);
        }
        return this.responses;
    }

    private static Map<String, org.mule.apikit.model.Response> loadResponses(Method method) {
        LinkedHashMap<String, org.mule.apikit.model.Response> result = new LinkedHashMap<String, org.mule.apikit.model.Response>();
        for (Response response : method.responses()) {
            result.put(response.code().value(), new ResponseImpl(response));
        }
        return result;
    }

    @Override
    public Resource getResource() {
        return new ResourceImpl(this.method.resource());
    }

    @Override
    public Map<String, MimeType> getBody() {
        if (this.bodies == null) {
            this.bodies = ActionImpl.loadBodies(this.method);
        }
        return this.bodies;
    }

    private static Map<String, MimeType> loadBodies(Method method) {
        LinkedHashMap<String, MimeType> result = new LinkedHashMap<String, MimeType>();
        for (TypeDeclaration typeDeclaration : method.body()) {
            result.put(typeDeclaration.name(), new MimeTypeImpl(typeDeclaration));
        }
        return result;
    }

    @Override
    public Map<String, Parameter> getQueryParameters() {
        if (this.queryParameters == null) {
            this.queryParameters = ActionImpl.loadQueryParameters(this.method);
        }
        return this.queryParameters;
    }

    private static Map<String, Parameter> loadQueryParameters(Method method) {
        HashMap<String, Parameter> result = new HashMap<String, Parameter>();
        for (TypeDeclaration typeDeclaration : method.queryParameters()) {
            result.put(typeDeclaration.name(), new ParameterImpl(typeDeclaration));
        }
        return result;
    }

    @Override
    public Map<String, List<Parameter>> getBaseUriParameters() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<String, Parameter> getResolvedUriParameters() {
        if (this.resolvedUriParameters == null) {
            this.resolvedUriParameters = ResourceImpl.loadResolvedUriParameters(this.method.resource());
        }
        return this.resolvedUriParameters;
    }

    @Override
    public Map<String, Parameter> getHeaders() {
        if (this.headers == null) {
            this.headers = this.loadHeaders(this.method);
        }
        return this.headers;
    }

    private Map<String, Parameter> loadHeaders(Method method) {
        HashMap<String, Parameter> result = new HashMap<String, Parameter>();
        for (TypeDeclaration typeDeclaration : method.headers()) {
            result.put(typeDeclaration.name(), new ParameterImpl(typeDeclaration));
        }
        return result;
    }

    @Override
    public List<SecurityReference> getSecuredBy() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<String> getIs() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void cleanBaseUriParameters() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setHeaders(Map<String, Parameter> headers) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setQueryParameters(Map<String, Parameter> queryParameters) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBody(Map<String, MimeType> body2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addResponse(String key, org.mule.apikit.model.Response response) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addSecurityReference(String securityReferenceName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addIs(String is) {
        throw new UnsupportedOperationException();
    }

    @Override
    public QueryString queryString() {
        return this.method.queryString() == null ? null : new QueryStringImpl(this.method.queryString());
    }

    @Override
    public String getSuccessStatusCode() {
        if (this.successStatusCode == null) {
            this.successStatusCode = Action.super.getSuccessStatusCode();
        }
        return this.successStatusCode;
    }
}

