/*
 * Decompiled with CFR 0.152.
 */
package org.mule.apikit.implv2.v10.model;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.apikit.implv2.parser.rule.ApiValidationResultImpl;
import org.mule.apikit.implv2.v10.model.ParameterImpl;
import org.mule.apikit.implv2.v10.model.RamlImpl10V2;
import org.mule.apikit.model.MimeType;
import org.mule.apikit.model.parameter.Parameter;
import org.mule.apikit.validation.ApiValidationResult;
import org.raml.v2.api.model.v10.datamodel.ExampleSpec;
import org.raml.v2.api.model.v10.datamodel.ObjectTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.UnionTypeDeclaration;

public class MimeTypeImpl
implements MimeType {
    private TypeDeclaration typeDeclaration;
    private Optional<String> typeAsString;

    public MimeTypeImpl(TypeDeclaration typeDeclaration) {
        this.typeDeclaration = typeDeclaration;
    }

    @Override
    public String getType() {
        return this.typeDeclaration.name();
    }

    @Override
    public String getExample() {
        ExampleSpec example = MimeTypeImpl.getExample(this.typeDeclaration);
        return example != null ? example.value() : null;
    }

    private static ExampleSpec getExample(TypeDeclaration typeDeclaration) {
        ExampleSpec localExample = MimeTypeImpl.getExampleFromLocal(typeDeclaration);
        if (localExample != null) {
            return localExample;
        }
        if (typeDeclaration instanceof ObjectTypeDeclaration) {
            return MimeTypeImpl.getExampleFromParent((ObjectTypeDeclaration)typeDeclaration);
        }
        if (typeDeclaration instanceof UnionTypeDeclaration) {
            List<TypeDeclaration> parentTypes = ((UnionTypeDeclaration)typeDeclaration).of();
            for (TypeDeclaration parentType : parentTypes) {
                ExampleSpec example = MimeTypeImpl.getExample(parentType);
                if (example == null) continue;
                return example;
            }
        }
        return null;
    }

    private static ExampleSpec getExampleFromLocal(TypeDeclaration typeDeclaration) {
        List nonNullExamples;
        ExampleSpec example = typeDeclaration.example();
        if (example != null && example.value() != null) {
            return example;
        }
        List<ExampleSpec> examples = typeDeclaration.examples();
        if (examples != null && !examples.isEmpty() && !(nonNullExamples = examples.stream().filter(e -> e.value() != null).collect(Collectors.toList())).isEmpty()) {
            return examples.get(0);
        }
        return null;
    }

    private static ExampleSpec getExampleFromParent(ObjectTypeDeclaration typeDeclaration) {
        if (!MimeTypeImpl.hasLocalProperties(typeDeclaration)) {
            for (TypeDeclaration declaration : typeDeclaration.parentTypes()) {
                ExampleSpec parentExample = MimeTypeImpl.getExample(declaration);
                if (parentExample == null) continue;
                return parentExample;
            }
        }
        return null;
    }

    private static boolean hasLocalProperties(ObjectTypeDeclaration typeDeclaration) {
        List<TypeDeclaration> parentTypes = typeDeclaration.parentTypes();
        if (parentTypes.isEmpty()) {
            return true;
        }
        int propertiesCount = typeDeclaration.properties().size();
        return parentTypes.stream().anyMatch(t2 -> t2 instanceof ObjectTypeDeclaration && ((ObjectTypeDeclaration)t2).properties().size() < propertiesCount);
    }

    @Override
    public String getSchema() {
        if (this.typeAsString == null) {
            this.typeAsString = Optional.ofNullable(RamlImpl10V2.getTypeAsString(this.typeDeclaration));
        }
        return this.typeAsString.orElse(null);
    }

    @Override
    public Map<String, List<Parameter>> getFormParameters() {
        LinkedHashMap<String, List<Parameter>> result = new LinkedHashMap<String, List<Parameter>>();
        if (this.typeDeclaration instanceof ObjectTypeDeclaration) {
            List<TypeDeclaration> parameters = ((ObjectTypeDeclaration)this.typeDeclaration).properties();
            for (TypeDeclaration parameter : parameters) {
                ArrayList<ParameterImpl> list = new ArrayList<ParameterImpl>();
                list.add(new ParameterImpl(parameter));
                result.put(parameter.name(), list);
            }
        }
        return result;
    }

    @Override
    public List<ApiValidationResult> validate(String payload) {
        return this.typeDeclaration.validate(payload).stream().map(ApiValidationResultImpl::new).collect(Collectors.toList());
    }

    @Override
    public Object getCompiledSchema() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getInstance() {
        throw new UnsupportedOperationException();
    }
}

