/*
 * Decompiled with CFR 0.152.
 */
package org.mule.apikit.implv2.v10.model;

import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.mule.apikit.ParserUtils;
import org.mule.apikit.implv2.v10.MetadataResolver;
import org.mule.apikit.model.parameter.FileProperties;
import org.mule.apikit.model.parameter.Parameter;
import org.mule.metadata.api.model.MetadataType;
import org.raml.v2.api.model.common.ValidationResult;
import org.raml.v2.api.model.v10.datamodel.ArrayTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.ExampleSpec;
import org.raml.v2.api.model.v10.datamodel.FileTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.NullTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.ObjectTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.UnionTypeDeclaration;
import org.raml.v2.api.model.v10.system.types.AnnotableStringType;
import org.raml.v2.api.model.v10.system.types.MarkdownString;
import org.raml.v2.internal.impl.v10.type.TypeId;

public class ParameterImpl
implements Parameter {
    private static final Set<String> NUMBER_DATA_TYPES = ImmutableSet.of(TypeId.NUMBER.getType(), TypeId.INTEGER.getType());
    private static final Set<String> BOOLEAN_DATA_TYPES = ImmutableSet.of(TypeId.BOOLEAN.getType());
    private TypeDeclaration typeDeclaration;
    private Collection<String> scalarTypes;
    private Boolean required;
    private String defaultValue;
    private final boolean typeNeedsQuotes;

    public ParameterImpl(TypeDeclaration typeDeclaration) {
        this.typeDeclaration = typeDeclaration;
        HashSet<TypeId> typeIds = Sets.newHashSet(TypeId.values());
        typeIds.remove((Object)TypeId.OBJECT);
        typeIds.remove((Object)TypeId.ARRAY);
        this.scalarTypes = Collections2.transform(typeIds, TypeId::getType);
        this.typeNeedsQuotes = this.needsQuotes(typeDeclaration);
    }

    @Override
    public boolean validate(String value) {
        List<ValidationResult> results = this.typeDeclaration.validate(value);
        return results.isEmpty();
    }

    @Override
    public boolean validateArray(Collection<?> values) {
        return this.validate(ParserUtils.getArrayAsYamlValue(this, values));
    }

    @Override
    public String message(String value) {
        List<ValidationResult> results = this.typeDeclaration.validate(value);
        return results.isEmpty() ? "OK" : results.get(0).getMessage();
    }

    @Override
    public String messageFromValues(Collection<?> values) {
        List<ValidationResult> results = this.typeDeclaration.validate(ParserUtils.getArrayAsYamlValue(this, values));
        return results.isEmpty() ? "OK" : results.get(0).getMessage();
    }

    @Override
    public boolean isRequired() {
        if (this.required == null) {
            this.required = this.typeDeclaration.required();
        }
        return this.required;
    }

    @Override
    public String getDefaultValue() {
        if (this.defaultValue != null) {
            return this.defaultValue;
        }
        this.defaultValue = this.typeDeclaration.defaultValue();
        return this.defaultValue;
    }

    @Override
    public List<String> getDefaultValues() {
        String value = this.getDefaultValue();
        return value != null ? Arrays.asList(value) : Collections.emptyList();
    }

    @Override
    public boolean isRepeat() {
        return false;
    }

    @Override
    public boolean isArray() {
        return this.typeDeclaration instanceof ArrayTypeDeclaration;
    }

    @Override
    public String getDisplayName() {
        AnnotableStringType type = this.typeDeclaration.displayName();
        return type == null ? null : type.value();
    }

    @Override
    public String getDescription() {
        MarkdownString description = this.typeDeclaration.description();
        return description == null ? null : description.value();
    }

    @Override
    public String getExample() {
        if (this.typeDeclaration.example() == null) {
            return null;
        }
        return this.typeDeclaration.example().value();
    }

    @Override
    public Map<String, String> getExamples() {
        LinkedHashMap<String, String> examples = new LinkedHashMap<String, String>();
        for (ExampleSpec example : this.typeDeclaration.examples()) {
            examples.put(example.name(), example.value());
        }
        return examples;
    }

    @Override
    public Object getInstance() {
        throw new UnsupportedOperationException();
    }

    @Override
    public MetadataType getMetadata() {
        return MetadataResolver.resolve(this.typeDeclaration).orElse(MetadataResolver.anyType());
    }

    @Override
    public boolean isScalar() {
        return ParameterImpl.isOfType(this.typeDeclaration, this.scalarTypes);
    }

    @Override
    public boolean isFacetArray(String facet) {
        if (this.typeDeclaration instanceof ObjectTypeDeclaration) {
            for (TypeDeclaration type : ((ObjectTypeDeclaration)this.typeDeclaration).properties()) {
                if (!type.name().equals(facet)) continue;
                return type instanceof ArrayTypeDeclaration;
            }
        }
        return false;
    }

    @Override
    public String surroundWithQuotesIfNeeded(String value) {
        return value != null && this.typeNeedsQuotes ? ParserUtils.quoteValue(ParserUtils.escapeSpecialCharsInYamlValue(value)) : value;
    }

    @Override
    public Optional<FileProperties> getFileProperties() {
        TypeDeclaration type = this.typeDeclaration;
        if (type instanceof ArrayTypeDeclaration) {
            type = ((ArrayTypeDeclaration)type).items();
        }
        if (type instanceof FileTypeDeclaration) {
            FileTypeDeclaration fileTypeDeclaration = (FileTypeDeclaration)type;
            Integer minLength = fileTypeDeclaration.minLength() != null ? fileTypeDeclaration.minLength().intValue() : 0;
            Integer maxLength = fileTypeDeclaration.maxLength() != null ? fileTypeDeclaration.maxLength().intValue() : 0;
            List<Object> fileTypes = fileTypeDeclaration.fileTypes() != null ? fileTypeDeclaration.fileTypes() : Collections.emptyList();
            return Optional.of(new FileProperties(minLength, maxLength, new HashSet<String>(fileTypes)));
        }
        return Optional.empty();
    }

    @Override
    public boolean isNullable() {
        return this.typeDeclaration instanceof NullTypeDeclaration || this.typeDeclaration instanceof UnionTypeDeclaration && ParameterImpl.hasNilShape((UnionTypeDeclaration)this.typeDeclaration);
    }

    private static boolean isOfType(TypeDeclaration type, Collection<String> typesCollection) {
        if (type.type() == null) {
            String[] types = type.name().split("\\|");
            return Arrays.stream(types).anyMatch(t2 -> typesCollection.contains(t2.trim()));
        }
        return typesCollection.contains(type.type()) || type.parentTypes() != null && !type.parentTypes().isEmpty() && type.parentTypes().stream().anyMatch(pt -> typesCollection.contains(pt.type()));
    }

    private boolean needsQuotes(TypeDeclaration typeDeclaration) {
        TypeDeclaration type = typeDeclaration;
        if (type instanceof ArrayTypeDeclaration) {
            if ((type = ((ArrayTypeDeclaration)type).items()) instanceof UnionTypeDeclaration) {
                return ((UnionTypeDeclaration)type).of().stream().anyMatch(t2 -> this.needsQuotes((TypeDeclaration)t2));
            }
            if (type instanceof ObjectTypeDeclaration || type instanceof ArrayTypeDeclaration) {
                return Boolean.FALSE;
            }
        } else {
            if (typeDeclaration instanceof UnionTypeDeclaration) {
                return ((UnionTypeDeclaration)typeDeclaration).of().stream().anyMatch(t2 -> this.needsQuotes((TypeDeclaration)t2));
            }
            if (!ParameterImpl.isOfType(type, this.scalarTypes)) {
                return Boolean.FALSE;
            }
        }
        return !ParameterImpl.isOfType(type, NUMBER_DATA_TYPES) && !ParameterImpl.isOfType(type, BOOLEAN_DATA_TYPES);
    }

    private static boolean hasNilShape(UnionTypeDeclaration unionType) {
        return unionType.of().stream().anyMatch(NullTypeDeclaration.class::isInstance);
    }
}

