/*
 * Decompiled with CFR 0.152.
 */
package org.mule.apikit.model.api;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Optional;
import org.apache.commons.io.FilenameUtils;
import org.mule.apikit.loader.ResourceLoader;
import org.mule.apikit.model.api.ApiReference;

class DefaultApiRef
implements ApiReference {
    private String location;
    private ResourceLoader resourceLoader;

    DefaultApiRef(String location) {
        this(location, null);
    }

    DefaultApiRef(String location, ResourceLoader resourceLoader) {
        this.location = location;
        this.resourceLoader = resourceLoader;
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    @Override
    public String getFormat() {
        return FilenameUtils.getExtension(this.location).toUpperCase();
    }

    @Override
    public InputStream resolve() {
        if (this.resourceLoader != null) {
            return this.resourceLoader.getResourceAsStream(this.location);
        }
        File file = new File(this.location);
        if (file.exists()) {
            try {
                return new FileInputStream(file);
            }
            catch (Exception e) {
                return null;
            }
        }
        return Thread.currentThread().getContextClassLoader().getResourceAsStream(this.location);
    }

    @Override
    public Optional<ResourceLoader> getResourceLoader() {
        return Optional.ofNullable(this.resourceLoader);
    }
}

