/*
 * Decompiled with CFR 0.152.
 */
package org.mule.apikit.scaffolding.internal.mapper;

import amf.apicontract.client.platform.AMFBaseUnitClient;
import amf.apicontract.client.platform.AMFConfiguration;
import amf.core.client.common.transform.PipelineId;
import amf.core.client.platform.AMFParseResult;
import amf.core.client.platform.AMFResult;
import amf.core.client.platform.config.RenderOptions;
import amf.core.client.platform.model.document.BaseUnit;
import amf.core.internal.remote.Spec;
import java.io.StringWriter;
import java.util.concurrent.ExecutionException;
import org.mule.apikit.scaffolding.internal.mapper.ApiGraphMapper;
import org.mule.apikit.scaffolding.internal.mapper.ApiGraphResult;
import org.mulesoft.common.io.Output;
import org.yaml.builder.JsonOutputBuilder;

public abstract class AmfApiGraphMapper
implements ApiGraphMapper {
    @Override
    public ApiGraphResult buildGraph(String api) {
        try {
            AMFParseResult parseResult = this.getClient(api).parse(api).get();
            BaseUnit model = parseResult.baseUnit();
            Spec spec = parseResult.sourceSpec();
            RenderOptions renderOptions = new RenderOptions().withAmfJsonLdSerialization().withoutSourceMaps().withoutPrettyPrint().withCompactUris();
            AMFConfiguration amfConfiguration = this.getConfiguration(spec).withRenderOptions(renderOptions);
            AMFResult transformResult = amfConfiguration.baseUnitClient().transform(model, PipelineId.Editing());
            StringWriter writer = new StringWriter();
            JsonOutputBuilder<StringWriter> jsonBuilder = JsonOutputBuilder.apply(writer, false, Output.outputWriter());
            amfConfiguration.baseUnitClient().renderGraphToBuilder(transformResult.baseUnit(), jsonBuilder);
            return new ApiGraphResult(spec.id(), ((Object)writer).toString());
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract AMFBaseUnitClient getClient(String var1);

    protected abstract AMFConfiguration getConfiguration(Spec var1);
}

