/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.api.builder;

import java.util.Optional;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.mule.metadata.api.annotation.Accessibility;
import org.mule.metadata.api.annotation.AccessibilityAnnotation;
import org.mule.metadata.api.annotation.DescriptionAnnotation;
import org.mule.metadata.api.annotation.FieldOccurrenceAnnotation;
import org.mule.metadata.api.annotation.LabelAnnotation;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.builder.AbstractBuilder;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectKeyBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.builder.WithAnnotation;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectKeyType;
import org.mule.metadata.api.model.impl.DefaultObjectFieldType;
import org.mule.metadata.internal.utils.LazyValue;

public class ObjectFieldTypeBuilder
extends AbstractBuilder<ObjectFieldType>
implements TypeBuilder<ObjectFieldType>,
WithAnnotation<ObjectFieldTypeBuilder> {
    private Optional<ObjectKeyBuilder> keyBuilder = Optional.empty();
    private Optional<? extends TypeBuilder<?>> valueBuilder = Optional.empty();
    private boolean required = false;
    private boolean repeated = false;
    private LazyValue<ObjectFieldType> result = new LazyValue();
    private MetadataType typeValue;

    public ObjectFieldTypeBuilder(MetadataFormat format) {
        super(format);
    }

    @Override
    public ObjectFieldTypeBuilder with(TypeAnnotation extension2) {
        this.addExtension(extension2);
        return this;
    }

    public ObjectFieldTypeBuilder withKeyAnnotation(TypeAnnotation extension2) {
        this.keyBuilder.ifPresent(builder -> builder.addExtension(extension2));
        return this;
    }

    public ObjectFieldTypeBuilder description(String lang, String content) {
        return this.with(new DescriptionAnnotation(content, lang));
    }

    public ObjectFieldTypeBuilder description(String content) {
        return this.with(new DescriptionAnnotation(content));
    }

    public ObjectFieldTypeBuilder required() {
        return this.required(true);
    }

    public ObjectFieldTypeBuilder required(boolean required) {
        this.required = required;
        return this;
    }

    public ObjectFieldTypeBuilder repeated(boolean repeated) {
        this.repeated = repeated;
        return this;
    }

    public ObjectFieldTypeBuilder accessibility(Accessibility accessibility) {
        return this.with(new AccessibilityAnnotation(accessibility));
    }

    public ObjectFieldTypeBuilder occurrence(Number min2, Number max) {
        return this.with(new FieldOccurrenceAnnotation(min2, max));
    }

    public ObjectFieldTypeBuilder label(String label) {
        this.withKeyAnnotation(new LabelAnnotation(label));
        return this;
    }

    public ObjectKeyBuilder key(QName keyName) {
        ObjectKeyBuilder keyBuilder = new ObjectKeyBuilder(this.format);
        keyBuilder.name(keyName);
        this.keyBuilder = Optional.of(keyBuilder);
        return keyBuilder;
    }

    public ObjectFieldTypeBuilder key(String keyName) {
        ObjectKeyBuilder keyBuilder = new ObjectKeyBuilder(this.format);
        keyBuilder.name(keyName);
        this.keyBuilder = Optional.of(keyBuilder);
        return this;
    }

    public ObjectFieldTypeBuilder key(Pattern pattern) {
        ObjectKeyBuilder keyBuilder = new ObjectKeyBuilder(this.format);
        keyBuilder.pattern(pattern);
        this.keyBuilder = Optional.of(keyBuilder);
        return this;
    }

    public BaseTypeBuilder value() {
        Optional<BaseTypeBuilder> typeBuilder = Optional.of(new BaseTypeBuilder(this.format));
        this.valueBuilder = typeBuilder;
        return typeBuilder.get();
    }

    public ObjectFieldTypeBuilder value(MetadataType typeValue) {
        this.typeValue = typeValue;
        return this;
    }

    public ObjectFieldTypeBuilder value(TypeBuilder<?> builder) {
        this.valueBuilder = Optional.of(builder);
        return this;
    }

    @Override
    public ObjectFieldType build() {
        return this.result.get(() -> {
            ObjectKeyType keyType = this.keyBuilder.orElseThrow(() -> new RuntimeException("No field key was specified for building the ObjectType.")).build();
            MetadataType value = this.typeValue != null ? this.typeValue : this.valueBuilder.orElseThrow(() -> new RuntimeException("No field value was specified for building the ObjectType.")).build();
            return new DefaultObjectFieldType(keyType, value, this.required, this.repeated, this.format, this.annotations);
        });
    }
}

