/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.api.builder;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.metadata.api.annotation.DescriptionAnnotation;
import org.mule.metadata.api.annotation.LabelAnnotation;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.annotation.TypeIdAnnotation;
import org.mule.metadata.api.builder.AbstractBuilder;
import org.mule.metadata.api.builder.AnyTypeBuilder;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectFieldTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.builder.WithAnnotation;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.impl.DefaultObjectType;
import org.mule.metadata.internal.utils.LazyValue;

public class ObjectTypeBuilder
extends AbstractBuilder<ObjectType>
implements TypeBuilder<ObjectType>,
WithAnnotation<ObjectTypeBuilder> {
    private List<ObjectFieldTypeBuilder> fieldsBuilder = new ArrayList<ObjectFieldTypeBuilder>();
    private boolean ordered = false;
    private Optional<TypeBuilder<?>> openRestriction;
    private Optional<MetadataType> openRestrictionType;
    private LazyValue<ObjectType> result = new LazyValue();

    public ObjectTypeBuilder(MetadataFormat format) {
        super(format);
        this.openRestriction = Optional.empty();
        this.openRestrictionType = Optional.empty();
    }

    public ObjectFieldTypeBuilder addField() {
        ObjectFieldTypeBuilder fieldMetadataBuilder = new ObjectFieldTypeBuilder(this.format);
        this.fieldsBuilder.add(fieldMetadataBuilder);
        return fieldMetadataBuilder;
    }

    public ObjectTypeBuilder ordered(boolean ordered) {
        this.ordered = ordered;
        return this;
    }

    public ObjectTypeBuilder id(String typeIdentifier) {
        return this.with(new TypeIdAnnotation(typeIdentifier));
    }

    @Override
    public ObjectTypeBuilder with(TypeAnnotation extension2) {
        this.addExtension(extension2);
        return this;
    }

    public ObjectTypeBuilder description(String lang, String content) {
        return this.with(new DescriptionAnnotation(content, lang));
    }

    public ObjectTypeBuilder description(String content) {
        return this.with(new DescriptionAnnotation(content));
    }

    public ObjectTypeBuilder label(String label) {
        return this.with(new LabelAnnotation(label));
    }

    public ObjectTypeBuilder open() {
        this.openRestriction = Optional.of(new AnyTypeBuilder(this.format));
        return this;
    }

    public BaseTypeBuilder openWith() {
        BaseTypeBuilder baseTypeBuilder = BaseTypeBuilder.create(this.format);
        this.openRestriction = Optional.of(baseTypeBuilder);
        return baseTypeBuilder;
    }

    public ObjectTypeBuilder openWith(TypeBuilder openRestriction) {
        this.openRestriction = Optional.of(openRestriction);
        return this;
    }

    public ObjectTypeBuilder openWith(MetadataType openRestriction) {
        this.openRestrictionType = Optional.of(openRestriction);
        return this;
    }

    @Override
    public ObjectType build() {
        ArrayList fields = new ArrayList();
        boolean needsInit = !this.result.isDefined();
        ObjectType objectType = this.result.get(() -> {
            MetadataType restrictionType = this.openRestriction.map(TypeBuilder::build).orElse(null);
            restrictionType = restrictionType == null ? (MetadataType)this.openRestrictionType.orElse(null) : restrictionType;
            return new DefaultObjectType(fields, this.ordered, restrictionType, this.format, this.annotations);
        });
        if (needsInit) {
            List collect2 = this.fieldsBuilder.stream().map(fieldBuilder -> fieldBuilder.build()).collect(Collectors.toList());
            fields.addAll(collect2);
        }
        return objectType;
    }
}

