/*
 * Decompiled with CFR 0.152.
 */
package org.mule.parser.service.strategy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import org.mule.amf.impl.AMFParser;
import org.mule.amf.impl.model.AMFImpl;
import org.mule.apikit.model.api.ApiReference;
import org.mule.apikit.validation.ApiValidationReport;
import org.mule.parser.service.result.DefaultParseResult;
import org.mule.parser.service.result.ExceptionParseResult;
import org.mule.parser.service.result.ParseResult;
import org.mule.parser.service.result.ParsingIssue;
import org.mule.parser.service.result.UnsupportedParsingIssue;
import org.mule.parser.service.strategy.ParsingStrategy;
import org.mule.parser.service.strategy.ValidationReportHelper;

public class AMFParsingStrategy
implements ParsingStrategy {
    private final boolean validate;
    private ScheduledExecutorService executor;

    public AMFParsingStrategy() {
        this(true);
    }

    public AMFParsingStrategy(boolean validate) {
        this.validate = validate;
    }

    @Override
    public ParseResult parse(ApiReference ref) {
        try {
            AMFParser parser2 = this.create(ref);
            if (!this.validate) {
                return new DefaultParseResult(parser2.parse(), Collections.emptyList(), Collections.emptyList());
            }
            ApiValidationReport report = parser2.validate();
            AMFImpl apiSpec = (AMFImpl)parser2.parse();
            List<ParsingIssue> warnings = ValidationReportHelper.warnings(report);
            warnings.addAll(this.getUnsupportedFeaturesWarnings(apiSpec));
            return new DefaultParseResult(apiSpec, ValidationReportHelper.errors(report), warnings);
        }
        catch (Exception e) {
            return new ExceptionParseResult(e);
        }
    }

    private List<ParsingIssue> getUnsupportedFeaturesWarnings(AMFImpl apiSpecification) {
        ArrayList<ParsingIssue> unsupportedFeatureMessages = new ArrayList<ParsingIssue>();
        if (apiSpecification.includesCallbacks()) {
            unsupportedFeatureMessages.add(new UnsupportedParsingIssue("OAS 3 - Callbacks are not supported yet."));
        }
        return unsupportedFeatureMessages;
    }

    @Override
    public void setExecutor(ScheduledExecutorService executor) {
        this.executor = executor;
    }

    private AMFParser create(ApiReference ref) {
        return new AMFParser(ref, this.executor);
    }
}

