/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.deployment.meta;

import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.mule.api.annotation.NoExtend;
import org.mule.runtime.api.deployment.meta.AbstractMuleArtifactModel;
import org.mule.runtime.api.deployment.meta.AbstractMuleArtifactModelBuilder;
import org.mule.runtime.api.deployment.meta.LicenseModel;
import org.mule.runtime.api.deployment.meta.LicenseModelBuilder;
import org.mule.runtime.api.deployment.meta.MuleArtifactLoaderDescriptor;
import org.mule.runtime.api.deployment.meta.MuleArtifactLoaderDescriptorBuilder;
import org.mule.runtime.api.deployment.meta.Product;
import org.mule.runtime.api.util.Preconditions;

@NoExtend
public class MulePluginModel
extends AbstractMuleArtifactModel {
    private final MuleArtifactLoaderDescriptor extensionModelLoaderDescriptor;
    private final LicenseModel license;

    private MulePluginModel(String name, String minMuleVersion, Product product2, MuleArtifactLoaderDescriptor classLoaderModelLoaderDescriptor, MuleArtifactLoaderDescriptor extensionModelLoaderDescriptor, MuleArtifactLoaderDescriptor bundleDescriptor, LicenseModel license) {
        super(name, minMuleVersion, product2, classLoaderModelLoaderDescriptor, bundleDescriptor);
        this.extensionModelLoaderDescriptor = extensionModelLoaderDescriptor;
        this.license = license;
    }

    public Optional<MuleArtifactLoaderDescriptor> getExtensionModelLoaderDescriptor() {
        return Optional.ofNullable(this.extensionModelLoaderDescriptor);
    }

    public Optional<LicenseModel> getLicense() {
        return Optional.ofNullable(this.license);
    }

    public static class MulePluginModelBuilder
    extends AbstractMuleArtifactModelBuilder<MulePluginModelBuilder, MulePluginModel> {
        private Optional<MuleArtifactLoaderDescriptorBuilder> extensionModelDescriptorBuilder = Optional.empty();
        private Optional<LicenseModelBuilder> licenseModelBuilder = Optional.empty();

        @Override
        protected MulePluginModelBuilder getThis() {
            return this;
        }

        public MuleArtifactLoaderDescriptorBuilder withExtensionModelDescriber() {
            if (!this.extensionModelDescriptorBuilder.isPresent()) {
                this.extensionModelDescriptorBuilder = Optional.of(new MuleArtifactLoaderDescriptorBuilder());
            }
            return this.extensionModelDescriptorBuilder.get();
        }

        public LicenseModelBuilder withLicenseModel() {
            if (!this.licenseModelBuilder.isPresent()) {
                this.licenseModelBuilder = Optional.of(new LicenseModelBuilder());
            }
            return this.licenseModelBuilder.get();
        }

        @Override
        public MulePluginModel build() {
            Preconditions.checkArgument(!StringUtils.isBlank(this.getName()), "name cannot be a blank");
            Preconditions.checkArgument(this.getBundleDescriptorLoader() != null, "bundleDescriber cannot be null");
            return new MulePluginModel(this.getName(), this.getMinMuleVersion(), this.getRequiredProduct(), this.getClassLoaderModelDescriptorLoader(), this.extensionModelDescriptorBuilder.isPresent() ? this.extensionModelDescriptorBuilder.get().build() : null, this.getBundleDescriptorLoader(), this.licenseModelBuilder.isPresent() ? this.licenseModelBuilder.get().build() : null);
        }
    }
}

