/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.meta;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class MuleVersion {
    private static final Pattern pattern = Pattern.compile("([0-9]+)(\\.)([0-9]+)(\\.([0-9]*))?(-(.+))?");
    public static final int NO_REVISION = -1;
    private int major = 0;
    private int minor = 0;
    private int revision = -1;
    private String suffix;

    public MuleVersion(String version2) {
        this.parse(version2);
    }

    public String toString() {
        StringBuilder v = new StringBuilder(this.major + "." + this.minor);
        if (this.revision >= 0) {
            v.append(".").append(this.revision);
        }
        if (this.suffix != null && this.suffix.trim().length() > 0) {
            v.append("-").append(this.suffix);
        }
        return v.toString();
    }

    private void parse(String version2) {
        Matcher m4 = pattern.matcher(version2);
        if (!m4.matches()) {
            throw new IllegalArgumentException("Invalid version " + version2);
        }
        try {
            this.major = Integer.parseInt(m4.group(1));
            this.minor = Integer.parseInt(m4.group(3));
            if (m4.group(4) != null && m4.group(4).startsWith(".")) {
                this.revision = Integer.parseInt(m4.group(5));
            }
            if (m4.group(6) != null && m4.group(6).startsWith("-")) {
                this.suffix = m4.group(7);
            }
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Invalid version " + version2);
        }
        if (!this.toString().equals(version2)) {
            throw new IllegalArgumentException("Invalid version " + version2);
        }
    }

    public boolean atLeast(String version2) {
        return this.atLeast(new MuleVersion(version2));
    }

    public boolean atLeast(MuleVersion version2) {
        return this.equals(version2) || this.newerThan(version2);
    }

    public boolean atLeastBase(String baseVersion) {
        return this.getBaseVersion().atLeastBase(new MuleVersion(baseVersion));
    }

    public boolean atLeastBase(MuleVersion baseVersion) {
        return this.getBaseVersion().atLeast(baseVersion.getBaseVersion());
    }

    public boolean sameBaseVersion(MuleVersion otherVersion) {
        return this.getBaseVersion().sameAs(otherVersion.getBaseVersion());
    }

    public boolean sameAs(String version2) {
        return this.sameAs(new MuleVersion(version2));
    }

    public boolean sameAs(MuleVersion version2) {
        return this.equals(version2);
    }

    public boolean priorTo(String version2) {
        return this.priorTo(new MuleVersion(version2));
    }

    public boolean priorTo(MuleVersion version2) {
        return !this.atLeast(version2);
    }

    public boolean newerThan(String version2) {
        return this.newerThan(new MuleVersion(version2));
    }

    public boolean newerThan(MuleVersion version2) {
        if (this.getMajor() > version2.getMajor()) {
            return true;
        }
        if (this.getMajor() == version2.getMajor()) {
            if (this.getMinor() > version2.getMinor()) {
                return true;
            }
            if (this.getMinor() == version2.getMinor()) {
                if (this.getRevision() > version2.getRevision()) {
                    return true;
                }
                if (this.getRevision() == version2.getRevision() || this.getRevision() <= 0 && version2.getRevision() <= 0) {
                    if (!this.hasSuffix() && version2.hasSuffix()) {
                        return true;
                    }
                    if (this.hasSuffix() && version2.hasSuffix()) {
                        return this.getSuffix().compareToIgnoreCase(version2.getSuffix()) > 0;
                    }
                }
            }
        }
        return false;
    }

    public String toCompleteNumericVersion() {
        StringBuilder v = new StringBuilder(this.major + "." + this.minor + ".");
        if (this.revision >= 0) {
            v.append(this.revision);
        } else {
            v.append("0");
        }
        return v.toString();
    }

    public boolean hasSuffix() {
        return this.getSuffix() != null && this.getSuffix().length() > 0;
    }

    private MuleVersion getBaseVersion() {
        return new MuleVersion(this.getMajor() + "." + this.getMinor());
    }

    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (!(otherObject instanceof MuleVersion)) {
            return false;
        }
        return this.toString().equals(otherObject.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public int getMajor() {
        return this.major;
    }

    public void setMajor(int major) {
        this.major = major;
    }

    public int getMinor() {
        return this.minor;
    }

    public void setMinor(int minor) {
        this.minor = minor;
    }

    public int getRevision() {
        return this.revision;
    }

    public void setRevision(int revision) {
        this.revision = revision;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }
}

