/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.meta.model.declaration.fluent.util;

import org.mule.runtime.api.meta.model.declaration.fluent.ConfigurationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConnectedDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConnectionProviderDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConstructDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterGroupDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterizedDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.WithConstructsDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.WithOperationsDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.WithSourcesDeclaration;
import org.mule.runtime.api.util.Preconditions;

public abstract class DeclarationWalker {
    private boolean stopped = false;

    public final void walk(ExtensionDeclaration extensionDeclaration) {
        Preconditions.checkArgument(extensionDeclaration != null, "Cannot walk a null declaration");
        this.stopped = false;
        for (ConfigurationDeclaration configuration : extensionDeclaration.getConfigurations()) {
            if (this.stopped) {
                return;
            }
            this.onConfiguration(configuration);
            this.ifContinue(() -> this.walkConnectionProviders(configuration));
            this.ifContinue(() -> this.walkParameters(configuration));
            this.ifContinue(() -> this.walkSources(configuration));
            this.ifContinue(() -> this.walkOperations(configuration));
        }
        this.ifContinue(() -> this.walkConnectionProviders(extensionDeclaration));
        this.ifContinue(() -> this.walkSources(extensionDeclaration));
        this.ifContinue(() -> this.walkOperations(extensionDeclaration));
        this.ifContinue(() -> this.walkConstructs(extensionDeclaration));
    }

    protected final void stop() {
        this.stopped = true;
    }

    protected void onConfiguration(ConfigurationDeclaration declaration) {
    }

    protected void onOperation(WithOperationsDeclaration owner, OperationDeclaration declaration) {
    }

    protected void onConstruct(WithConstructsDeclaration owner, ConstructDeclaration declaration) {
    }

    protected void onConnectionProvider(ConnectedDeclaration owner, ConnectionProviderDeclaration declaration) {
    }

    protected void onSource(WithSourcesDeclaration owner, SourceDeclaration declaration) {
    }

    protected void onParameterGroup(ParameterizedDeclaration owner, ParameterGroupDeclaration declaration) {
    }

    protected void onParameter(ParameterizedDeclaration owner, ParameterGroupDeclaration parameterGroup, ParameterDeclaration declaration) {
    }

    private void walkConstructs(WithConstructsDeclaration<?> declaration) {
        for (ConstructDeclaration construct : declaration.getConstructs()) {
            if (this.stopped) {
                return;
            }
            this.onConstruct(declaration, construct);
            this.ifContinue(() -> this.walkParameters(construct));
        }
    }

    private void walkSources(WithSourcesDeclaration declaration) {
        for (SourceDeclaration source : declaration.getMessageSources()) {
            if (this.stopped) {
                return;
            }
            SourceDeclaration sourceDeclaration = source;
            this.onSource(declaration, sourceDeclaration);
            this.ifContinue(() -> this.walkParameters(sourceDeclaration));
            this.ifContinue(() -> sourceDeclaration.getSuccessCallback().ifPresent(this::walkParameters));
            this.ifContinue(() -> sourceDeclaration.getErrorCallback().ifPresent(this::walkParameters));
        }
    }

    private void walkParameters(ParameterizedDeclaration declaration) {
        for (ParameterGroupDeclaration g2 : declaration.getParameterGroups()) {
            if (this.stopped) {
                return;
            }
            ParameterGroupDeclaration group = g2;
            this.onParameterGroup(declaration, group);
            this.ifContinue(() -> this.walkGroupParameters(declaration, group));
        }
    }

    private void walkGroupParameters(ParameterizedDeclaration declaration, ParameterGroupDeclaration group) {
        for (ParameterDeclaration p : group.getParameters()) {
            if (this.stopped) {
                return;
            }
            this.onParameter(declaration, group, p);
        }
    }

    private void walkConnectionProviders(ConnectedDeclaration declaration) {
        for (ConnectionProviderDeclaration provider : declaration.getConnectionProviders()) {
            if (this.stopped) {
                return;
            }
            ConnectionProviderDeclaration providerDeclaration = provider;
            this.onConnectionProvider(declaration, providerDeclaration);
            this.ifContinue(() -> this.walkParameters(providerDeclaration));
        }
    }

    private void walkOperations(WithOperationsDeclaration model) {
        for (OperationDeclaration operation : model.getOperations()) {
            if (this.stopped) {
                return;
            }
            OperationDeclaration declaration = operation;
            this.onOperation(model, declaration);
            this.ifContinue(() -> this.walkParameters(declaration));
        }
    }

    private void ifContinue(Runnable action) {
        if (!this.stopped) {
            action.run();
        }
    }
}

