/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.meta.model.stereotype;

import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import org.mule.runtime.api.util.NameUtils;
import org.mule.runtime.api.util.Preconditions;

public final class ImmutableStereotypeModel
implements StereotypeModel {
    private String type;
    private String namespace;
    private StereotypeModel parent;

    public ImmutableStereotypeModel(String name, String namespace, StereotypeModel parent) {
        Preconditions.checkArgument(StringUtils.isNotBlank(name), "An stereotype name is required");
        Preconditions.checkArgument(StringUtils.isNotBlank(namespace), "An stereotype namespace is required");
        this.type = this.normalize(name);
        this.namespace = this.normalize(namespace);
        this.parent = parent;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public Optional<StereotypeModel> getParent() {
        return Optional.ofNullable(this.parent);
    }

    @Override
    public boolean isAssignableTo(StereotypeModel other) {
        Preconditions.checkArgument(other != null, "Null is not a valid stereotype");
        boolean assignable = this.equals(other);
        if (!assignable && this.parent != null) {
            assignable = this.parent.isAssignableTo(other);
        }
        return assignable;
    }

    public boolean equals(Object obj) {
        if (obj == null || !obj.getClass().equals(ImmutableStereotypeModel.class)) {
            return false;
        }
        ImmutableStereotypeModel that = (ImmutableStereotypeModel)obj;
        return Objects.equals(this.parent, that.parent) && Objects.equals(this.type, that.type) && Objects.equals(this.namespace, that.namespace);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.namespace, this.parent);
    }

    public String toString() {
        return this.namespace + ":" + this.type + (this.parent == null ? "" : "(" + this.parent.toString() + ")");
    }

    private String normalize(String name) {
        return NameUtils.sanitizeName(NameUtils.underscorize(name)).toUpperCase();
    }
}

