/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.internal.app.declaration.serialization;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.lang.reflect.Type;
import org.mule.runtime.api.app.declaration.serialization.ArtifactDeclarationJsonSerializer;
import org.mule.runtime.app.declaration.api.ArtifactDeclaration;
import org.mule.runtime.app.declaration.api.ParameterGroupElementDeclaration;
import org.mule.runtime.app.declaration.api.ParameterValue;
import org.mule.runtime.internal.app.declaration.serialization.adapter.ElementDeclarationTypeAdapterFactory;
import org.mule.runtime.internal.app.declaration.serialization.adapter.ParameterGroupElementDeclarationTypeAdapter;
import org.mule.runtime.internal.app.declaration.serialization.adapter.ParameterValueTypeAdapter;

public class DefaultArtifactDeclarationJsonSerializer
implements ArtifactDeclarationJsonSerializer {
    private boolean prettyPrint;

    public DefaultArtifactDeclarationJsonSerializer(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    @Override
    public String serialize(ArtifactDeclaration declaration) {
        return this.createGson().toJson(declaration);
    }

    @Override
    public ArtifactDeclaration deserialize(String declaration) {
        return this.createGson().fromJson(declaration, ArtifactDeclaration.class);
    }

    private Gson createGson() {
        GsonBuilder gsonBuilder = new GsonBuilder().registerTypeAdapterFactory(new ElementDeclarationTypeAdapterFactory()).registerTypeAdapter((Type)((Object)ParameterValue.class), new ParameterValueTypeAdapter()).registerTypeAdapter((Type)((Object)ParameterGroupElementDeclaration.class), new ParameterGroupElementDeclarationTypeAdapter());
        if (this.prettyPrint) {
            gsonBuilder.setPrettyPrinting();
        }
        return gsonBuilder.create();
    }
}

