/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.apikit.input;

import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mule.apikit.model.Action;
import org.mule.apikit.model.ApiSpecification;
import org.mule.apikit.model.MimeType;
import org.mule.apikit.model.Resource;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.tools.apikit.misc.APIKitTools;
import org.mule.tools.apikit.model.APIFactory;
import org.mule.tools.apikit.model.ApikitMainFlowContainer;
import org.mule.tools.apikit.model.ResourceActionMimeTypeTriplet;
import org.mule.tools.apikit.output.GenerationModel;

public class RAMLFilesParser {
    public static final String MULE_APIKIT_PARSER = "mule.apikit.parser";
    private final APIFactory apiFactory;
    private final Set<ApikitMainFlowContainer> apis = new HashSet<ApikitMainFlowContainer>();
    private Map<ResourceActionMimeTypeTriplet, GenerationModel> entries = new HashMap<ResourceActionMimeTypeTriplet, GenerationModel>();

    public RAMLFilesParser(APIFactory apiFactory, ApiSpecification apiSpec) {
        this.apiFactory = apiFactory;
        this.collectResources(apiSpec.getLocation(), apiSpec.getResources(), "http://0.0.0.0:8081/api", apiSpec.getVersion());
    }

    public List<ApikitMainFlowContainer> getApisAsList() {
        return Lists.newArrayList(this.apis);
    }

    public Map<ResourceActionMimeTypeTriplet, GenerationModel> getEntries() {
        return this.entries;
    }

    private void collectResources(String filePath, Map<String, Resource> resourceMap, String baseUri, String version2) {
        ApikitMainFlowContainer api = this.apiFactory.createAPIBinding(filePath, baseUri, APIKitTools.getPathFromUri(baseUri, false), null, null, null);
        this.apis.add(api);
        for (Resource resource : resourceMap.values()) {
            for (Action action : resource.getActions().values()) {
                Map<String, MimeType> mimeTypes = action.getBody();
                if (mimeTypes != null && !mimeTypes.isEmpty()) {
                    for (MimeType mimeType : mimeTypes.values()) {
                        this.addResource(api, resource, action, mimeType.getType(), version2);
                    }
                    continue;
                }
                this.addResource(api, resource, action, null, version2);
            }
            this.collectResources(filePath, resource.getResources(), baseUri, version2);
        }
    }

    private void addResource(ApikitMainFlowContainer api, Resource resource, Action action, String mimeType, String version2) {
        String completePath = APIKitTools.getCompletePathFromBasePathAndPath(api.getHttpListenerConfig().getBasePath(), api.getPath());
        String mimeTypeWithoutAttributes = mimeType != null ? this.getMediaType(mimeType) : null;
        ResourceActionMimeTypeTriplet resourceActionTriplet = new ResourceActionMimeTypeTriplet(api, completePath + resource.getResolvedUri(version2), action.getType().toString(), mimeTypeWithoutAttributes);
        this.entries.put(resourceActionTriplet, new GenerationModel(api, version2, resource, action, mimeTypeWithoutAttributes));
    }

    private String getMediaType(String mediaType) {
        MediaType mType = MediaType.parse(mediaType);
        return String.format("%s/%s", mType.getPrimaryType(), mType.getSubType());
    }
}

