/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.apikit.input.parsers;

import java.util.ArrayList;
import java.util.List;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.filter.Filters;
import org.jdom2.xpath.XPathExpression;
import org.jdom2.xpath.XPathFactory;
import org.mule.tools.apikit.input.parsers.MuleConfigFileParser;
import org.mule.tools.apikit.model.HttpListenerConfig;
import org.mule.tools.apikit.model.HttpListenerConnection;
import org.mule.tools.apikit.output.MuleConfigGenerator;

public class HttpListenerConfigParser
implements MuleConfigFileParser<List<HttpListenerConfig>> {
    private static final String ELEMENT_NAME = "listener-config";
    private static final XPathExpression<Element> LISTENER_COMPILED_EXPRESSION = HttpListenerConfigParser.getCompiledExpression();

    private static XPathExpression<Element> getCompiledExpression() {
        return XPathFactory.instance().compile("//*/*[local-name()='listener-config']", Filters.element(MuleConfigGenerator.HTTP_NAMESPACE.getNamespace()));
    }

    @Override
    public List<HttpListenerConfig> parse(Document document) {
        ArrayList<HttpListenerConfig> httpListenerConfigMap = new ArrayList<HttpListenerConfig>();
        List<Element> elements = LISTENER_COMPILED_EXPRESSION.evaluate(document);
        for (Element element : elements) {
            String name = element.getAttributeValue("name");
            if (name == null) {
                throw new IllegalStateException("Cannot retrieve name.");
            }
            String basePath = element.getAttributeValue("basePath");
            if (basePath == null) {
                basePath = "/";
            } else if (!basePath.startsWith("/")) {
                basePath = "/" + basePath;
            }
            for (Element child : element.getChildren()) {
                String protocol;
                if (!child.getName().equals("listener-connection")) continue;
                String host = child.getAttributeValue("host");
                if (host == null) {
                    throw new IllegalStateException("Cannot retrieve host.");
                }
                String port = child.getAttributeValue("port");
                if (port == null) {
                    port = Integer.toString(8081);
                }
                if ((protocol = child.getAttributeValue("protocol")) == null) {
                    protocol = "HTTP";
                }
                HttpListenerConfig httpListenerConfig = new HttpListenerConfig(name, basePath, new HttpListenerConnection(host, port, protocol));
                httpListenerConfig.setPersisted(true);
                httpListenerConfigMap.add(httpListenerConfig);
            }
        }
        return httpListenerConfigMap;
    }
}

