/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.apikit.misc;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.jdom2.Namespace;
import org.mule.tools.apikit.output.NamespaceWithLocation;

public class APIKitTools {
    public static final NamespaceWithLocation API_KIT_NAMESPACE = new NamespaceWithLocation(Namespace.getNamespace("apikit", "http://www.mulesoft.org/schema/mule/mule-apikit"), "http://www.mulesoft.org/schema/mule/mule-apikit/current/mule-apikit.xsd");

    public static String getPathFromUri(String baseUri, boolean addAsterisk) {
        int slash;
        int start = baseUri.indexOf("//") + 2;
        if (start == -1) {
            start = 0;
        }
        if ((slash = baseUri.indexOf("/", start)) == -1 || slash == baseUri.length()) {
            return addAsterisk ? "/*" : "/";
        }
        String path = baseUri.substring(slash, baseUri.length());
        int curlyBrace = baseUri.indexOf("{", slash);
        if (curlyBrace == -1) {
            return addAsterisk ? APIKitTools.addAsteriskToPath(path) : path;
        }
        path = baseUri.substring(slash, curlyBrace);
        return addAsterisk ? APIKitTools.addAsteriskToPath(path) : path;
    }

    public static String addAsteriskToPath(String path) {
        if (path == null) {
            return "/*";
        }
        if (!path.endsWith("*")) {
            path = path.endsWith("/") ? path + "*" : path + "/*";
        }
        return path;
    }

    public static String getProtocolFromUri(String baseUri) {
        if (baseUri.contains("//")) {
            return baseUri.substring(0, baseUri.indexOf("//")).toUpperCase();
        }
        return "HTTP";
    }

    public static String getHostFromUri(String baseUri) {
        int slash;
        int twoDots;
        int start = baseUri.indexOf("//") + 2;
        if (start == -1) {
            start = 0;
        }
        if ((twoDots = baseUri.indexOf(":", start)) == -1) {
            twoDots = baseUri.length();
        }
        if ((slash = baseUri.indexOf("/", start)) == -1) {
            slash = baseUri.length();
        }
        int hostEnd = twoDots < slash ? twoDots : slash;
        return baseUri.substring(start, hostEnd);
    }

    public static String getPortFromUri(String baseUri) {
        int twoDots;
        int slash;
        int hostStart = baseUri.indexOf("//") + 2;
        if (hostStart == -1) {
            hostStart = 0;
        }
        if ((slash = baseUri.indexOf("/", hostStart)) == -1) {
            slash = baseUri.length();
        }
        if ((twoDots = baseUri.indexOf(":", hostStart)) == -1 || twoDots > slash) {
            return Integer.toString(8081);
        }
        return baseUri.substring(twoDots + 1, slash);
    }

    public static String getCompletePathFromBasePathAndPath(String basePath, String listenerPath) {
        String path = basePath + listenerPath;
        if (path.contains("/*")) {
            path = path.replace("/*", "");
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if (path.contains("//")) {
            path = path.replace("//", "/");
        }
        return path;
    }

    public static boolean defaultIsInboundEndpoint(String candidateVersion) {
        if (candidateVersion == null) {
            return false;
        }
        String[] versionParts = candidateVersion.split("\\.");
        if (versionParts.length < 2) {
            return false;
        }
        int major = Integer.parseInt(versionParts[0]);
        int minor = Integer.parseInt(versionParts[1]);
        return major == 3 && minor < 6;
    }

    public static boolean canExtensionsBeEnabled(String candidateVersion) {
        if (candidateVersion == null) {
            return false;
        }
        String[] versionParts = candidateVersion.split("\\.");
        if (versionParts.length < 2) {
            return false;
        }
        int major = Integer.parseInt(versionParts[0]);
        int minor = Integer.parseInt(versionParts[1]);
        return major > 3 || major == 3 && minor >= 7;
    }

    public static String readContents(File fileToRead) throws IOException {
        return APIKitTools.readContents(new FileInputStream(fileToRead));
    }

    public static String readContents(InputStream streamToRead) throws IOException {
        try {
            String string = IOUtils.toString(streamToRead);
            return string;
        }
        finally {
            IOUtils.closeQuietly(streamToRead);
        }
    }
}

