/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.apikit.model;

import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.mule.tools.apikit.misc.APIKitTools;

public class HttpListenerConnection {
    private String host;
    private String port;
    private String protocol;

    public static Builder builder() {
        return new Builder();
    }

    public HttpListenerConnection(String host, String port, String protocol) {
        this.host = host;
        this.port = port;
        this.protocol = protocol;
    }

    public String getHost() {
        return this.host;
    }

    public String getPort() {
        return this.port;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpListenerConnection that = (HttpListenerConnection)o;
        return Objects.equals(this.host, that.host) && Objects.equals(this.port, that.port) && Objects.equals(this.protocol, that.protocol);
    }

    public int hashCode() {
        return Objects.hash(this.host, this.port, this.protocol);
    }

    public static class Builder {
        private String host;
        private String port;
        private String protocol;

        public Builder(String host, String port, String protocol) {
            if (StringUtils.isEmpty(host)) {
                throw new IllegalArgumentException("Name attribute cannot be null or empty");
            }
            if (StringUtils.isEmpty(port)) {
                throw new IllegalArgumentException("Host attribute cannot be null or empty");
            }
            this.host = host;
            this.port = port;
            this.protocol = protocol;
        }

        public Builder() {
            this.host = APIKitTools.getHostFromUri("http://0.0.0.0:8081/api");
            this.port = APIKitTools.getPortFromUri("http://0.0.0.0:8081/api");
            this.protocol = "HTTP";
        }

        public Builder setHost(String host) {
            this.host = host;
            return this;
        }

        public Builder setPort(String port) {
            this.port = port;
            return this;
        }

        public Builder setProtocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public HttpListenerConnection build() {
            return new HttpListenerConnection(this.host, this.port, this.protocol);
        }
    }
}

