/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.apikit.model;

import com.google.common.collect.Lists;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.mule.tools.apikit.model.APIKitConfig;
import org.mule.tools.apikit.model.Flow;
import org.mule.tools.apikit.model.HttpListenerConfig;
import org.mule.tools.apikit.model.MainFlow;
import org.mule.tools.apikit.model.NamedContent;
import org.mule.tools.apikit.model.WithConfigs;
import org.mule.tools.apikit.model.WithConstructs;

public class MuleConfig
implements NamedContent,
WithConstructs,
WithConfigs {
    private String name;
    private Document originalContent;
    private List<HttpListenerConfig> configurations;
    private List<APIKitConfig> apikitConfigs;
    private List<Flow> flows;
    private static final String INDENTATION = "    ";

    protected MuleConfig(List<HttpListenerConfig> configurations, List<APIKitConfig> apikitConfigs, List<Flow> flows) {
        this.configurations = configurations;
        this.apikitConfigs = apikitConfigs;
        this.flows = flows;
    }

    protected MuleConfig(List<HttpListenerConfig> httpConfigs, List<APIKitConfig> apikitConfigs, List<Flow> flows, Document content) {
        this(httpConfigs, apikitConfigs, flows);
        this.originalContent = content;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Document getContentAsDocument() {
        return this.originalContent;
    }

    @Override
    public InputStream getContent() {
        Format prettyFormat = Format.getPrettyFormat();
        prettyFormat.setIndent(INDENTATION);
        prettyFormat.setLineSeparator(System.getProperty("line.separator"));
        prettyFormat.setEncoding("UTF-8");
        XMLOutputter xout = new XMLOutputter(prettyFormat);
        String contentAsString = xout.outputString(this.originalContent);
        return IOUtils.toInputStream(contentAsString);
    }

    @Override
    public List<HttpListenerConfig> getHttpListenerConfigs() {
        return Collections.unmodifiableList(this.configurations);
    }

    public void addHttpListener(HttpListenerConfig config) {
        this.configurations.add(config);
    }

    @Override
    public List<Flow> getFlows() {
        return Collections.unmodifiableList(this.flows);
    }

    public void addConfig(APIKitConfig value) {
        this.apikitConfigs.add(value);
    }

    public List<APIKitConfig> getApikitConfigs() {
        return Lists.newArrayList(this.apikitConfigs);
    }

    public List<MainFlow> getMainFlows() {
        List mainFlows = this.flows.stream().filter(flow -> flow instanceof MainFlow).map(MainFlow.class::cast).collect(Collectors.toList());
        return Collections.unmodifiableList(mainFlows);
    }

    public Document buildContent() {
        Document document = new Document();
        Element rootElement = this.originalContent.getRootElement().clone().detach();
        rootElement.setContent(new ArrayList());
        document.setRootElement(rootElement);
        for (HttpListenerConfig config : this.configurations) {
            if (config.isPersisted()) continue;
            this.addContent(document, config.generate());
        }
        this.apikitConfigs.forEach(apiKitConfig -> this.addContent(document, apiKitConfig.generate()));
        this.flows.forEach(flow -> this.addContent(document, flow.generate().clone().detach()));
        return document;
    }

    public void addFlow(Flow flow) {
        this.flows.add(flow);
    }

    private void addContent(Document document, Element element) {
        document.getRootElement().getContent().add(element);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MuleConfig that = (MuleConfig)o;
        return Objects.equals(this.originalContent, that.originalContent) && Objects.equals(this.configurations, that.configurations) && Objects.equals(this.apikitConfigs, that.apikitConfigs);
    }

    public int hashCode() {
        return Objects.hash(this.originalContent, this.configurations, this.apikitConfigs);
    }
}

