/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.apikit.output.scopes;

import org.apache.commons.lang.StringUtils;
import org.jdom2.Element;
import org.mule.tools.apikit.misc.APIKitTools;
import org.mule.tools.apikit.model.ApikitMainFlowContainer;
import org.mule.tools.apikit.output.MuleConfigGenerator;
import org.mule.tools.apikit.output.scopes.ErrorHandlerScope;
import org.mule.tools.apikit.output.scopes.MainFlowsUtils;
import org.mule.tools.apikit.output.scopes.Scope;

public class FlowScope
implements Scope {
    private final Element main = new Element("flow", MuleConfigGenerator.XMLNS_NAMESPACE.getNamespace());

    public FlowScope(ApikitMainFlowContainer api, boolean isMuleEE) {
        String configRef;
        this.main.setAttribute("name", api.getId() + "-main");
        String httpListenerConfigRef = api.getHttpListenerConfig().getName();
        this.main.addContent(MainFlowsUtils.generateListenerSource(httpListenerConfigRef, api.getPath()));
        Element restProcessor = new Element("router", APIKitTools.API_KIT_NAMESPACE.getNamespace());
        String string = configRef = api.getConfig() != null ? api.getConfig().getName() : null;
        if (!StringUtils.isEmpty(configRef)) {
            restProcessor.setAttribute("config-ref", configRef);
        }
        Element errorHandler = ErrorHandlerScope.createForMainFlow(isMuleEE).generate();
        this.main.addContent(restProcessor);
        this.main.addContent(errorHandler);
    }

    @Override
    public Element generate() {
        return this.main;
    }
}

