/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.module.core.json.reader.indexed;

import org.mule.weave.v2.model.structure.BufferedCharSequence;
import org.mule.weave.v2.model.structure.StreamSourceBufferedCharSequenceReader;
import org.mule.weave.v2.module.core.json.reader.indexed.UnescapeChars;
import org.mule.weave.v2.module.core.json.reader.indexed.UnescapedJsonBufferedCharSequenceReader$;
import org.mule.weave.v2.module.core.json.reader.indexed.UnescapedJsonBufferedCharSequenceReaderPosition;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\ra\u0001\u0002\t\u0012\u0001\u0011B\u0001b\u000e\u0001\u0003\u0002\u0003\u0006I\u0001\u000f\u0005\u0006w\u0001!\t\u0001\u0010\u0005\b\u007f\u0001\u0001\r\u0011\"\u0003A\u0011\u001d\t\u0005\u00011A\u0005\n\tCa\u0001\u0013\u0001!B\u0013\u0019\u0004\"B%\u0001\t\u0003R\u0005\"B&\u0001\t\u0003b\u0005\"\u0002(\u0001\t\u0003z\u0005\"\u0002)\u0001\t\u0003\n\u0006\"B3\u0001\t\u00131\u0007\"B<\u0001\t\u0003Bx!B=\u0012\u0011\u0003Qh!\u0002\t\u0012\u0011\u0003Y\b\"B\u001e\u000e\t\u0003a\b\"B?\u000e\t\u0003q(aJ+oKN\u001c\u0017\r]3e\u0015N|gNQ;gM\u0016\u0014X\rZ\"iCJ\u001cV-];f]\u000e,'+Z1eKJT!AE\n\u0002\u000f%tG-\u001a=fI*\u0011A#F\u0001\u0007e\u0016\fG-\u001a:\u000b\u0005Y9\u0012\u0001\u00026t_:T!\u0001G\r\u0002\t\r|'/\u001a\u0006\u00035m\ta!\\8ek2,'B\u0001\u000f\u001e\u0003\t1(G\u0003\u0002\u001f?\u0005)q/Z1wK*\u0011\u0001%I\u0001\u0005[VdWMC\u0001#\u0003\ry'oZ\u0002\u0001'\r\u0001Qe\u000b\t\u0003M%j\u0011a\n\u0006\u0002Q\u0005)1oY1mC&\u0011!f\n\u0002\u0007\u0003:L(+\u001a4\u0011\u00071\n4'D\u0001.\u0015\tqs&A\u0005tiJ,8\r^;sK*\u0011\u0001gG\u0001\u0006[>$W\r\\\u0005\u0003e5\u0012ae\u0015;sK\u0006l7k\\;sG\u0016\u0014UO\u001a4fe\u0016$7\t[1s'\u0016\fX/\u001a8dKJ+\u0017\rZ3s!\t!T'D\u0001\u0012\u0013\t1\u0014CA\u0018V]\u0016\u001c8-\u00199fI*\u001bxN\u001c\"vM\u001a,'/\u001a3DQ\u0006\u00148+Z9vK:\u001cWMU3bI\u0016\u0014\bk\\:ji&|g.A\u0002cGN\u0004\"\u0001L\u001d\n\u0005ij#\u0001\u0006\"vM\u001a,'/\u001a3DQ\u0006\u00148+Z9vK:\u001cW-\u0001\u0004=S:LGO\u0010\u000b\u0003{y\u0002\"\u0001\u000e\u0001\t\u000b]\u0012\u0001\u0019\u0001\u001d\u0002\u0013}\u0003xn]5uS>tW#A\u001a\u0002\u001b}\u0003xn]5uS>tw\fJ3r)\t\u0019e\t\u0005\u0002'\t&\u0011Qi\n\u0002\u0005+:LG\u000fC\u0004H\t\u0005\u0005\t\u0019A\u001a\u0002\u0007a$\u0013'\u0001\u0006`a>\u001c\u0018\u000e^5p]\u0002\nQA]3tKR$\u0012aQ\u0001\u0005g\u0016,7\u000e\u0006\u0002D\u001b\")aj\u0002a\u0001g\u0005A\u0001o\\:ji&|g\u000eF\u00014\u0003\u0011\u0011X-\u00193\u0015\u0005I\u0003\u0007c\u0001\u0014T+&\u0011Ak\n\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005YkfBA,\\!\tAv%D\u0001Z\u0015\tQ6%\u0001\u0004=e>|GOP\u0005\u00039\u001e\na\u0001\u0015:fI\u00164\u0017B\u00010`\u0005\u0019\u0019FO]5oO*\u0011Al\n\u0005\u0006C&\u0001\rAY\u0001\u0007Y\u0016tw\r\u001e5\u0011\u0005\u0019\u001a\u0017B\u00013(\u0005\rIe\u000e^\u0001\u0017k:,7oY1qK\u000eC\u0017M]:V]RLGnU5{KR!qM\u001b7n!\t!\u0004.\u0003\u0002j#\tiQK\\3tG\u0006\u0004Xm\u00115beNDQa\u001b\u0006A\u0002\t\faa\u001c4gg\u0016$\b\"B1\u000b\u0001\u0004\u0011\u0007\"\u00028\u000b\u0001\u0004y\u0017AB:pkJ\u001cW\r\u0005\u0002qk6\t\u0011O\u0003\u0002sg\u0006!A.\u00198h\u0015\u0005!\u0018\u0001\u00026bm\u0006L!A^9\u0003\u0019\rC\u0017M]*fcV,gnY3\u0002\u000fI,\u0017\rZ!mYR\tQ+A\u0014V]\u0016\u001c8-\u00199fI*\u001bxN\u001c\"vM\u001a,'/\u001a3DQ\u0006\u00148+Z9vK:\u001cWMU3bI\u0016\u0014\bC\u0001\u001b\u000e'\tiQ\u0005F\u0001{\u0003\u0015\t\u0007\u000f\u001d7z)\tit\u0010\u0003\u0004\u0002\u0002=\u0001\r\u0001O\u0001\u0003GN\u0004")
public class UnescapedJsonBufferedCharSequenceReader
implements StreamSourceBufferedCharSequenceReader<UnescapedJsonBufferedCharSequenceReaderPosition> {
    private final BufferedCharSequence bcs;
    private UnescapedJsonBufferedCharSequenceReaderPosition _position;

    public static UnescapedJsonBufferedCharSequenceReader apply(BufferedCharSequence bufferedCharSequence) {
        return UnescapedJsonBufferedCharSequenceReader$.MODULE$.apply(bufferedCharSequence);
    }

    private UnescapedJsonBufferedCharSequenceReaderPosition _position() {
        return this._position;
    }

    private void _position_$eq(UnescapedJsonBufferedCharSequenceReaderPosition x$1) {
        this._position = x$1;
    }

    @Override
    public void reset() {
        this.seek(new UnescapedJsonBufferedCharSequenceReaderPosition(0));
    }

    @Override
    public void seek(UnescapedJsonBufferedCharSequenceReaderPosition position) {
        this._position_$eq(position);
    }

    @Override
    public UnescapedJsonBufferedCharSequenceReaderPosition position() {
        return this._position();
    }

    @Override
    public Option<String> read(int length) {
        Option option;
        UnescapeChars unescapeChars = this.unescapeCharsUntilSize(this._position().index(), length, this.bcs);
        if (unescapeChars.unescaped().isEmpty()) {
            option = None$.MODULE$;
        } else {
            this._position_$eq(new UnescapedJsonBufferedCharSequenceReaderPosition(unescapeChars.lastIndexRead() + 1));
            option = new Some<String>(unescapeChars.unescaped());
        }
        return option;
    }

    private UnescapeChars unescapeCharsUntilSize(int offset, int length, CharSequence source) {
        int index = offset;
        StringBuilder b = new StringBuilder();
        for (int charsCounter = 0; charsCounter < length; ++charsCounter) {
            try {
                StringBuilder stringBuilder;
                char c = source.charAt(index);
                int nextIndex = index + 1;
                if (c == '\\') {
                    char controlChar = source.charAt(nextIndex);
                    ++nextIndex;
                    char c2 = controlChar;
                    switch (c2) {
                        case '\"': 
                        case '/': 
                        case '\\': {
                            stringBuilder = b.append(controlChar);
                            break;
                        }
                        case 'n': {
                            stringBuilder = b.append('\n');
                            break;
                        }
                        case 'b': {
                            stringBuilder = b.append('\b');
                            break;
                        }
                        case 'f': {
                            stringBuilder = b.append('\f');
                            break;
                        }
                        case 'r': {
                            stringBuilder = b.append('\r');
                            break;
                        }
                        case 't': {
                            stringBuilder = b.append('\t');
                            break;
                        }
                        case 'u': {
                            char[] hexChars = new char[4];
                            for (int idx = 0; idx < 4; ++idx) {
                                char unicodeChar = source.charAt(nextIndex);
                                ++nextIndex;
                                hexChars[idx] = unicodeChar;
                            }
                            int codePoint = Integer.parseInt(new String(hexChars), 16);
                            stringBuilder = b.appendCodePoint(codePoint);
                            break;
                        }
                        default: {
                            throw new MatchError(BoxesRunTime.boxToCharacter(c2));
                        }
                    }
                } else {
                    stringBuilder = b.append(c);
                }
                index = nextIndex;
                continue;
            }
            catch (Exception exception) {
                return new UnescapeChars(index - 1, b.toString());
            }
        }
        return new UnescapeChars(index - 1, b.toString());
    }

    @Override
    public String readAll() {
        String unescapeChars = this.bcs.toString();
        this._position_$eq(new UnescapedJsonBufferedCharSequenceReaderPosition(unescapeChars.length()));
        return this.unescapeCharsUntilSize(0, unescapeChars.length(), unescapeChars).unescaped();
    }

    public UnescapedJsonBufferedCharSequenceReader(BufferedCharSequence bcs) {
        this.bcs = bcs;
        this._position = new UnescapedJsonBufferedCharSequenceReaderPosition(0);
    }
}

