/*
 * Decompiled with CFR 0.152.
 */
package org.raml.parser;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.raml.parser.ResolveResourceException;
import org.raml.parser.loader.ResourceLoader;
import org.raml.parser.rule.LSInputImpl;
import org.raml.parser.tagresolver.ContextPath;
import org.raml.parser.utils.StreamUtils;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;

public class XsdResourceResolver
implements LSResourceResolver {
    private final ContextPath contextPath;
    private final ResourceLoader resourceLoader;

    public XsdResourceResolver(ContextPath contextPath, ResourceLoader resourceLoader) {
        this.contextPath = contextPath;
        this.resourceLoader = resourceLoader;
    }

    @Override
    public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
        byte[] content;
        if (systemId == null) {
            return null;
        }
        String path = this.contextPath.resolveAbsolutePath(systemId);
        if (path == null || path.startsWith("http://") || path.startsWith("https://") || path.startsWith("file:")) {
            return null;
        }
        if (new File(systemId).isAbsolute()) {
            return null;
        }
        InputStream inputStream = this.resourceLoader.fetchResource(path);
        if (inputStream == null) {
            return null;
        }
        try {
            content = IOUtils.toByteArray(inputStream);
        }
        catch (IOException e) {
            throw new ResolveResourceException(e);
        }
        return new LSInputImpl(publicId, systemId, baseURI, new ByteArrayInputStream(content), StreamUtils.detectEncoding(content));
    }
}

