/*
 * Decompiled with CFR 0.152.
 */
package org.raml.parser.completion;

import java.util.ArrayList;
import java.util.List;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.NodeId;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;

public class NodeContext {
    private int parentIndentation;
    private int siblingsIndentation;
    private MappingNode mappingNode;

    public NodeContext(int parentIndentation, MappingNode mappingNode) {
        this.parentIndentation = parentIndentation;
        this.siblingsIndentation = -1;
        this.mappingNode = mappingNode;
    }

    public int getParentIndentation() {
        return this.parentIndentation;
    }

    public int getSiblingsIndentation() {
        return this.siblingsIndentation;
    }

    public List<String> getKeys() {
        ArrayList<String> keys = new ArrayList<String>();
        if (this.mappingNode != null) {
            for (NodeTuple tuple2 : this.mappingNode.getValue()) {
                String value;
                if (tuple2.getKeyNode().getNodeId() == NodeId.scalar && !(value = ((ScalarNode)tuple2.getKeyNode()).getValue()).equals("/ResourceName")) {
                    keys.add(value);
                }
                if (this.siblingsIndentation != -1) continue;
                this.siblingsIndentation = tuple2.getKeyNode().getStartMark().getColumn();
            }
        }
        return keys;
    }
}

