/*
 * Decompiled with CFR 0.152.
 */
package org.raml.parser.rule;

import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.raml.parser.resolver.DefaultScalarTupleHandler;
import org.raml.parser.rule.DefaultTupleRule;
import org.raml.parser.rule.TupleRule;
import org.raml.parser.rule.TypedTupleRule;
import org.raml.parser.rule.ValidationMessage;
import org.raml.parser.rule.ValidationResult;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;

public class ImplicitMapEntryRule
extends DefaultTupleRule<ScalarNode, MappingNode>
implements TypedTupleRule {
    private Class valueType;
    private final Set<String> keys = new HashSet<String>();

    public ImplicitMapEntryRule(String fieldName, Class valueType) {
        super(fieldName, new DefaultScalarTupleHandler(fieldName));
        this.valueType = valueType;
    }

    @Override
    public TupleRule<?, ?> getRuleForTuple(NodeTuple nodeTuple) {
        if (this.rules.isEmpty()) {
            this.addRulesFor(this.valueType);
        }
        return super.getRuleForTuple(nodeTuple);
    }

    @Override
    public List<ValidationResult> onRuleEnd() {
        List<ValidationResult> validationResults = super.onRuleEnd();
        this.rules.clear();
        return validationResults;
    }

    @Override
    public Class<?>[] getValueNodeType() {
        return new Class[]{MappingNode.class};
    }

    @Override
    public void setValueType(Type valueType) {
        this.valueType = (Class)valueType;
    }

    @Override
    public TupleRule<?, ?> deepCopy() {
        this.checkClassToCopy(ImplicitMapEntryRule.class);
        ImplicitMapEntryRule copy = new ImplicitMapEntryRule(this.getName(), this.getValueType());
        copy.setNodeRuleFactory(this.getNodeRuleFactory());
        copy.setHandler(this.getHandler());
        return copy;
    }

    @Override
    public Class<?> getValueType() {
        return this.valueType;
    }

    @Override
    public List<ValidationResult> validateKey(ScalarNode key) {
        List<ValidationResult> validationResults = super.validateKey(key);
        if (this.keys.contains(key.getValue())) {
            validationResults.add(ValidationResult.createErrorResult(ValidationMessage.getDuplicateRuleMessage(this.getName()), key));
        } else {
            this.keys.add(key.getValue());
        }
        return validationResults;
    }
}

