/*
 * Decompiled with CFR 0.152.
 */
package org.raml.parser.tagresolver;

import com.google.common.collect.Lists;
import java.util.List;
import org.raml.parser.loader.ResourceLoader;
import org.raml.parser.tagresolver.ContextPath;
import org.raml.parser.tagresolver.ContextPathAware;
import org.raml.parser.tagresolver.TagResolver;
import org.raml.parser.visitor.IncludeInfo;
import org.raml.parser.visitor.NodeHandler;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.Tag;

public class CompoundIncludeResolver
implements TagResolver,
ContextPathAware {
    public static final String INCLUDE_COMPOUND_APPLIED_TAG = "!include-compound_";
    private ContextPath contextPath;

    public static List<IncludeInfo> unmarshall(Tag tag2) {
        String compoundIncludeTag = tag2.getValue().substring(INCLUDE_COMPOUND_APPLIED_TAG.length());
        int endOfFirstLength = compoundIncludeTag.indexOf("_");
        int firstIncludeLength = Integer.parseInt(compoundIncludeTag.substring(0, endOfFirstLength));
        String firstAppliedInclude = compoundIncludeTag.substring(endOfFirstLength + 1, endOfFirstLength + 1 + firstIncludeLength);
        IncludeInfo firstIncludeInfo = new IncludeInfo(new Tag(firstAppliedInclude));
        String compoundIncludeTag1 = compoundIncludeTag.substring(endOfFirstLength + 1 + firstIncludeLength + 1);
        int endOfSecondLength = compoundIncludeTag1.indexOf("_");
        int secondIncludeLength = Integer.parseInt(compoundIncludeTag1.substring(0, endOfSecondLength));
        String secondAppliedInclude = compoundIncludeTag1.substring(endOfSecondLength + 1, endOfSecondLength + 1 + secondIncludeLength);
        IncludeInfo secondIncludeInfo = new IncludeInfo(new Tag(secondAppliedInclude));
        return Lists.newArrayList(firstIncludeInfo, secondIncludeInfo);
    }

    @Override
    public void setContextPath(ContextPath contextPath) {
        this.contextPath = contextPath;
    }

    @Override
    public ContextPath getContextPath() {
        return this.contextPath;
    }

    @Override
    public boolean handles(Tag tag2) {
        return tag2.startsWith(INCLUDE_COMPOUND_APPLIED_TAG);
    }

    @Override
    public Node resolve(Node valueNode, ResourceLoader resourceLoader, NodeHandler nodeHandler) {
        return valueNode;
    }

    @Override
    public void beforeProcessingResolvedNode(Tag tag2, Node originalNode, Node resolvedNode) {
        if (tag2.startsWith(INCLUDE_COMPOUND_APPLIED_TAG)) {
            List<IncludeInfo> includes = CompoundIncludeResolver.unmarshall(tag2);
            for (IncludeInfo include : includes) {
                this.contextPath.push(include);
            }
        }
    }

    @Override
    public void afterProcessingResolvedNode(Tag tag2, Node originalNode, Node resolvedNode) {
        if (tag2.startsWith(INCLUDE_COMPOUND_APPLIED_TAG)) {
            List<IncludeInfo> includes = CompoundIncludeResolver.unmarshall(tag2);
            for (IncludeInfo include : includes) {
                this.contextPath.pop();
            }
        }
    }
}

