/*
 * Decompiled with CFR 0.152.
 */
package org.raml.parser.visitor;

import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.commons.lang.StringUtils;
import org.raml.parser.XsdResourceResolver;
import org.raml.parser.loader.ResourceLoader;
import org.raml.parser.tagresolver.ContextPath;
import org.raml.parser.tagresolver.IncludeResolver;
import org.raml.parser.visitor.IncludeInfo;
import org.yaml.snakeyaml.nodes.ScalarNode;

public final class SchemaCompiler {
    private static final String SEPARATOR = "-|_";
    private static final SchemaCompiler instance = new SchemaCompiler();
    private ContextPath contextPath;
    private ResourceLoader resourceLoader;

    private SchemaCompiler() {
    }

    public static SchemaCompiler getInstance() {
        return instance;
    }

    public void init(ContextPath contextPath, ResourceLoader resourceLoader) {
        if (contextPath == null || resourceLoader == null) {
            throw new IllegalArgumentException("Neither contextPath nor resourceLoader can be null");
        }
        this.contextPath = contextPath;
        this.resourceLoader = resourceLoader;
    }

    public Map<String, Object> compile(Map<String, String> encodedSchemas) {
        HashMap<String, Object> compiledSchemas = new HashMap<String, Object>();
        for (Map.Entry<String, String> encodedSchema : encodedSchemas.entrySet()) {
            String[] pathAndSchema = SchemaCompiler.decodeIncludePath(encodedSchema.getValue());
            Schema compiledSchema = this.compile(pathAndSchema[1], pathAndSchema[0]);
            if (compiledSchema != null) {
                compiledSchemas.put(encodedSchema.getKey(), compiledSchema);
            } else if (StringUtils.isNotBlank(pathAndSchema[0])) {
                compiledSchemas.put(encodedSchema.getKey(), pathAndSchema[0]);
            }
            encodedSchema.setValue(pathAndSchema[1]);
        }
        return compiledSchemas;
    }

    public Schema compile(String schema, String path) {
        Schema compiledSchema = null;
        String trimmedSchema = StringUtils.trimToEmpty(schema);
        if (trimmedSchema.startsWith("<") && trimmedSchema.endsWith(">")) {
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            ContextPath actualContextPath = this.contextPath;
            if (path != null) {
                actualContextPath = new ContextPath(new IncludeInfo(path));
            }
            factory.setResourceResolver(new XsdResourceResolver(actualContextPath, this.resourceLoader));
            try {
                compiledSchema = factory.newSchema(new StreamSource(new StringReader(trimmedSchema)));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return compiledSchema;
    }

    public Schema compile(String schema) {
        return this.compile(schema, null);
    }

    public static String encodeIncludePath(ScalarNode node) {
        String schema = node.getValue();
        String includePath = "";
        if (node instanceof IncludeResolver.IncludeScalarNode) {
            includePath = ((IncludeResolver.IncludeScalarNode)node).getIncludeName();
        }
        String includeEncoded = DatatypeConverter.printBase64Binary(includePath.getBytes());
        return includeEncoded + SEPARATOR + schema;
    }

    public static String[] decodeIncludePath(String encodedSchema) {
        int idx = encodedSchema.indexOf(SEPARATOR);
        if (idx == -1) {
            throw new IllegalArgumentException("Invalid include encoded schema.");
        }
        String base64Path = encodedSchema.substring(0, idx);
        String includePath = new String(DatatypeConverter.parseBase64Binary(base64Path));
        String schema = encodedSchema.substring(idx + SEPARATOR.length(), encodedSchema.length());
        return new String[]{includePath, schema};
    }
}

