/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.impl;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.raml.v2.api.loader.DefaultResourceLoader;
import org.raml.v2.api.loader.ResourceLoader;
import org.raml.v2.internal.impl.RamlBuilder;
import org.raml.v2.internal.impl.commons.RamlHeader;
import org.raml.v2.internal.utils.Inflector;
import org.raml.yagi.framework.grammar.rule.Rule;
import org.raml.yagi.framework.nodes.EmptyErrorNode;
import org.raml.yagi.framework.nodes.ErrorNode;
import org.raml.yagi.framework.nodes.KeyValueNode;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.nodes.ObjectNode;
import org.raml.yagi.framework.nodes.StringNode;
import org.raml.yagi.framework.suggester.DefaultSuggestion;
import org.raml.yagi.framework.suggester.ParsingContext;
import org.raml.yagi.framework.suggester.ParsingContextType;
import org.raml.yagi.framework.suggester.Suggestion;
import org.raml.yagi.framework.suggester.Suggestions;
import org.raml.yagi.framework.util.NodeUtils;

public class RamlSuggester {
    private ResourceLoader resourceLoader;

    public RamlSuggester(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public RamlSuggester() {
        this(new DefaultResourceLoader());
    }

    public Suggestions suggestions(String document, int offset) {
        ArrayList<Suggestion> result = new ArrayList<Suggestion>();
        ParsingContext parsingContext = this.getContext(document, offset);
        int location = parsingContext.getLocation();
        String content = parsingContext.getContent();
        List<Suggestion> suggestions = this.getSuggestions(parsingContext, document, offset, location);
        if (content.isEmpty()) {
            result.addAll(suggestions);
        } else {
            for (Suggestion suggestion : suggestions) {
                if (!suggestion.getValue().startsWith(content)) continue;
                result.add(suggestion);
            }
        }
        Collections.sort(result);
        return new Suggestions(result, content, location);
    }

    private List<Suggestion> getSuggestions(ParsingContext context, String document, int offset, int location) {
        switch (context.getContextType()) {
            case HEADER: {
                return this.getHeaderSuggestions();
            }
            case FUNCTION_CALL: {
                return this.getFunctionCallSuggestions();
            }
            case STRING_TEMPLATE: {
                return this.getTemplateParameterSuggestions(document, offset, location);
            }
            case LIBRARY_CALL: 
            case ITEM: 
            case VALUE: {
                return this.getSuggestionsAt(context, document, offset, location);
            }
        }
        return this.getSuggestionByColumn(context, document, offset, location);
    }

    @Nonnull
    private List<Suggestion> getTemplateParameterSuggestions(String document, int offset, int location) {
        Node rootNode = this.getRootNode(document, offset, location);
        boolean inTrait = false;
        for (Node node = NodeUtils.searchNodeAt(rootNode, location); node != null; node = node.getParent()) {
            String value;
            if (!(node instanceof KeyValueNode) || !(((KeyValueNode)node).getKey() instanceof StringNode) || !(value = ((StringNode)((KeyValueNode)node).getKey()).getValue()).equals("traits") && !value.equals("resourceTypes")) continue;
            inTrait = value.equals("traits");
            break;
        }
        return inTrait ? this.defaultTraitParameters() : this.defaultResourceTypeParameters();
    }

    @Nonnull
    private List<Suggestion> defaultTraitParameters() {
        List<Suggestion> suggestions = this.defaultResourceTypeParameters();
        suggestions.add(new DefaultSuggestion("methodName", "The name of the method", ""));
        return suggestions;
    }

    @Nonnull
    private List<Suggestion> defaultResourceTypeParameters() {
        ArrayList<Suggestion> suggestions = new ArrayList<Suggestion>();
        suggestions.add(new DefaultSuggestion("resourcePath", "The resource's full URI relative to the baseUri (if any)", ""));
        suggestions.add(new DefaultSuggestion("resourcePathName", "The rightmost path fragment of the resource's relative URI, omitting any parametrize brackets (\"{\" and \"}\")", ""));
        return suggestions;
    }

    @Nonnull
    private List<Suggestion> getFunctionCallSuggestions() {
        Method[] declaredMethods;
        ArrayList<Suggestion> suggestions = new ArrayList<Suggestion>();
        for (Method declaredMethod : declaredMethods = Inflector.class.getDeclaredMethods()) {
            if (!Modifier.isStatic(declaredMethod.getModifiers()) || !Modifier.isPublic(declaredMethod.getModifiers())) continue;
            suggestions.add(new DefaultSuggestion("!" + declaredMethod.getName(), "", declaredMethod.getName()));
        }
        return suggestions;
    }

    private List<Suggestion> getSuggestionsAt(ParsingContext context, String document, int offset, int location) {
        Node root = this.getRootNode(document, offset, location);
        Node node = NodeUtils.searchNodeAt(root, location);
        if (node != null) {
            if (node.getParent() instanceof KeyValueNode && node.getParent().getChildren().indexOf(node) == 0) {
                node = node.getParent().getParent();
            }
            List<Node> pathToRoot = this.createPathToRoot(node);
            Rule rootRule = this.getRuleFor(document);
            return rootRule != null ? rootRule.getSuggestions(pathToRoot, context) : Collections.emptyList();
        }
        return Collections.emptyList();
    }

    private Node getRootNode(String document, int offset, int location) {
        RamlBuilder ramlBuilder = new RamlBuilder(RamlBuilder.FIRST_PHASE);
        try {
            Node rootNode = ramlBuilder.build(document, this.resourceLoader, "");
            if (rootNode instanceof StringNode) {
                Node rootNode2 = ramlBuilder.build(this.stripLastChanges(document, offset, location) + "\n\nstub: stub", this.resourceLoader, "");
                if (rootNode2 instanceof ErrorNode) {
                    return ramlBuilder.build(this.removeChangedLine(document, offset, location) + "\n\nstub: stub", this.resourceLoader, "");
                }
                return rootNode2;
            }
            if (!(rootNode instanceof ErrorNode)) {
                return rootNode;
            }
            if (rootNode instanceof EmptyErrorNode) {
                return ramlBuilder.build(document + "\n\nstub: stub", this.resourceLoader, "");
            }
            return ramlBuilder.build(this.removeChangedLine(document, offset, location) + "\n\nstub: stub", this.resourceLoader, "");
        }
        catch (Exception e) {
            return ramlBuilder.build(this.stripLastChanges(document, offset, location), this.resourceLoader, "");
        }
    }

    private String removeChangedLine(String document, int offset, int location) {
        String header = document.substring(0, location + 1);
        String footer = this.getFooter1(document, offset);
        return header + footer;
    }

    private String stripLastChanges(String document, int offset, int location) {
        String header = document.substring(0, location + 1);
        String footer = this.getFooter(document, offset);
        return header + footer;
    }

    private List<Suggestion> getSuggestionByColumn(ParsingContext context, String document, int offset, int location) {
        int columnNumber = this.getColumnNumber(document, offset);
        Node root = this.getRootNode(document, offset, location);
        Node node = NodeUtils.searchNodeAt(root, location);
        if (node != null) {
            node = this.getValueNodeAtColumn(columnNumber, node);
            List<Node> pathToRoot = this.createPathToRoot(node);
            Rule rootRule = this.getRuleFor(document);
            return rootRule != null ? rootRule.getSuggestions(pathToRoot, context) : Collections.emptyList();
        }
        return Collections.emptyList();
    }

    private int getLineNumber(String document, int offset) {
        int lineNumber = 0;
        for (int currentIndex = 0; currentIndex <= offset; ++currentIndex) {
            if (currentIndex - 1 == offset || currentIndex >= document.length()) {
                return lineNumber;
            }
            if (document.charAt(currentIndex) != '\n') continue;
            ++lineNumber;
        }
        return lineNumber;
    }

    private List<Suggestion> getHeaderSuggestions() {
        return Arrays.asList(new DefaultSuggestion("#%RAML 1.0", "RAML 1.0 root file header", "RAML 1.0 Header"), new DefaultSuggestion("#%RAML 1.0 DocumentationItem", "An item in the collection of items that is the value of the root-level documentation property", "RAML 1.0 Documentation Item fragment"), new DefaultSuggestion("#%RAML 1.0 DataType", "A data type declaration where the type property may be used", "RAML 1.0 Data Type fragment"), new DefaultSuggestion("#%RAML 1.0 NamedExample", "A property of the examples property, whose key is a name of an example and whose value describes the example", "RAML 1.0 Named Example fragment"), new DefaultSuggestion("#%RAML 1.0 ResourceType", "A single resource type declaration", "RAML 1.0 Resource Type fragment"), new DefaultSuggestion("#%RAML 1.0 Trait", "A single trait declaration", "RAML 1.0 Trait fragment"), new DefaultSuggestion("#%RAML 1.0 AnnotationTypeDeclaration", "A single annotation type declaration", "RAML 1.0 Annotation Type Declaration fragment"), new DefaultSuggestion("#%RAML 1.0 Library", "A RAML library", "RAML 1.0 Library fragment"), new DefaultSuggestion("#%RAML 1.0 Overlay", "An overlay file", "RAML 1.0 Overlay fragment"), new DefaultSuggestion("#%RAML 1.0 Extension", "An extension file", "RAML 1.0 Extension fragment"), new DefaultSuggestion("#%RAML 1.0 SecurityScheme", "A definition of a security scheme", "RAML 1.0 Security Scheme fragment"));
    }

    @Nonnull
    private ParsingContext getContext(String document, int offset) {
        int location;
        if (offset == -1 || this.getLineNumber(document, offset) == 0) {
            String content = offset < 0 || document.isEmpty() ? "" : document.substring(0, offset + 1);
            return new ParsingContext(ParsingContextType.HEADER, content, offset);
        }
        ParsingContext context = null;
        StringBuilder content = new StringBuilder();
        block7: for (location = offset; location >= 0 && context == null; --location) {
            char character = document.charAt(location);
            switch (character) {
                case ':': {
                    context = new ParsingContext(ParsingContextType.VALUE, this.revertAndTrim(content), location + 1);
                    continue block7;
                }
                case ',': 
                case '-': 
                case '[': 
                case '{': {
                    context = new ParsingContext(ParsingContextType.ITEM, this.revertAndTrim(content), location);
                    continue block7;
                }
                case '<': {
                    if (location > 0 && document.charAt(location - 1) == '<') {
                        --location;
                        String contextContent = this.revertAndTrim(content);
                        String[] split = contextContent.split("\\|");
                        if (split.length > 1) {
                            context = new ParsingContext(ParsingContextType.FUNCTION_CALL, split[split.length - 1].trim(), location);
                            continue block7;
                        }
                        if (contextContent.endsWith("|")) {
                            context = new ParsingContext(ParsingContextType.FUNCTION_CALL, "", location);
                            continue block7;
                        }
                        context = new ParsingContext(ParsingContextType.STRING_TEMPLATE, contextContent, location);
                        continue block7;
                    }
                    content.append(character);
                    continue block7;
                }
                case '.': {
                    context = new ParsingContext(ParsingContextType.LIBRARY_CALL, this.revertAndTrim(content), location);
                    continue block7;
                }
                case '\n': {
                    context = new ParsingContext(ParsingContextType.ANY, this.revertAndTrim(content), location);
                    continue block7;
                }
                default: {
                    content.append(character);
                }
            }
        }
        if (context == null) {
            context = new ParsingContext(ParsingContextType.ANY, this.revertAndTrim(content), location);
        }
        return context;
    }

    @Nonnull
    private String revertAndTrim(StringBuilder content) {
        return content.reverse().toString().trim();
    }

    private Node getValueNodeAtColumn(int columnNumber, Node node) {
        if (columnNumber == 0) {
            return node.getRootNode();
        }
        List<Node> path = this.createPathToRoot(node);
        for (Node element : path) {
            if (element instanceof KeyValueNode) {
                if (element.getStartPosition().getColumn() >= columnNumber) continue;
                node = ((KeyValueNode)element).getValue();
                continue;
            }
            if (!(element instanceof ObjectNode) || element.getStartPosition().getColumn() > columnNumber) continue;
            node = element;
        }
        return node;
    }

    @Nonnull
    private List<Node> createPathToRoot(Node node) {
        ArrayList<Node> path = new ArrayList<Node>();
        for (Node parent = node; parent != null; parent = parent.getParent()) {
            path.add(0, parent);
        }
        return path;
    }

    @Nonnull
    private String getFooter(String document, int offset) {
        int loc = offset;
        char current = document.charAt(loc);
        while (loc < document.length() && current != '\n' && current != '}' && current != ']' && current != ',' && ++loc != document.length()) {
            current = document.charAt(loc);
        }
        return loc < document.length() ? document.substring(loc) : "";
    }

    @Nonnull
    private String getFooter1(String document, int offset) {
        return this.getFooter(document, offset + 1);
    }

    private int getColumnNumber(String document, int offset) {
        StringBuilder contextLine = this.getContextLine(document, offset);
        int columnNumber = 0;
        for (int i = 0; i < contextLine.length() && Character.isWhitespace(contextLine.charAt(i)); ++i) {
            ++columnNumber;
        }
        return columnNumber;
    }

    @Nonnull
    private StringBuilder getContextLine(String document, int offset) {
        StringBuilder contextLine = new StringBuilder();
        if (offset < 0) {
            return contextLine;
        }
        int location = offset;
        char character = document.charAt(location);
        while (location > 0 && character != '\n') {
            contextLine.append(character);
            character = document.charAt(--location);
        }
        return contextLine.reverse();
    }

    @Nullable
    public Rule getRuleFor(String stringContent) {
        try {
            RamlHeader ramlHeader = RamlHeader.parse(stringContent);
            return ramlHeader.getRule();
        }
        catch (RamlHeader.InvalidHeaderException invalidHeaderException) {
            return null;
        }
    }
}

