/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.impl.commons.grammar;

import com.google.common.base.Function;
import com.google.common.collect.Sets;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.raml.v2.internal.impl.commons.grammar.UriTemplateValidationRule;
import org.raml.v2.internal.impl.commons.nodes.BodyNode;
import org.raml.v2.internal.impl.commons.nodes.MethodNode;
import org.raml.v2.internal.impl.commons.nodes.ParametrizedResourceTypeRefNode;
import org.raml.v2.internal.impl.commons.nodes.ParametrizedSecuritySchemeRefNode;
import org.raml.v2.internal.impl.commons.nodes.ParametrizedTraitRefNode;
import org.raml.v2.internal.impl.commons.nodes.RamlDocumentNode;
import org.raml.v2.internal.impl.commons.nodes.ResourceNode;
import org.raml.v2.internal.impl.commons.nodes.ResourceTypeNode;
import org.raml.v2.internal.impl.commons.nodes.ResourceTypeRefNode;
import org.raml.v2.internal.impl.commons.nodes.SecuritySchemeNode;
import org.raml.v2.internal.impl.commons.nodes.SecuritySchemeRefNode;
import org.raml.v2.internal.impl.commons.nodes.TraitNode;
import org.raml.v2.internal.impl.commons.nodes.TraitRefNode;
import org.raml.v2.internal.impl.commons.phase.StringTemplateExpressionTransformer;
import org.raml.v2.internal.impl.commons.rule.NodeReferenceFactory;
import org.raml.v2.internal.impl.commons.rule.NodeReferenceRule;
import org.raml.v2.internal.impl.commons.rule.ParametrizedNodeReferenceRule;
import org.raml.v2.internal.impl.v10.nodes.factory.EmptyObjectNodeFactory;
import org.raml.v2.internal.impl.v10.nodes.factory.OverlayableSimpleTypeFactory;
import org.raml.v2.internal.impl.v10.nodes.factory.TypeExpressionReferenceFactory;
import org.raml.yagi.framework.grammar.BaseGrammar;
import org.raml.yagi.framework.grammar.ExclusiveSiblingRule;
import org.raml.yagi.framework.grammar.RuleFactory;
import org.raml.yagi.framework.grammar.RuleTraverser;
import org.raml.yagi.framework.grammar.rule.AnyOfRule;
import org.raml.yagi.framework.grammar.rule.ArrayRule;
import org.raml.yagi.framework.grammar.rule.ArrayWrapperFactory;
import org.raml.yagi.framework.grammar.rule.KeyValueRule;
import org.raml.yagi.framework.grammar.rule.ObjectRule;
import org.raml.yagi.framework.grammar.rule.RegexValueRule;
import org.raml.yagi.framework.grammar.rule.Rule;
import org.raml.yagi.framework.grammar.rule.StringValueRule;
import org.raml.yagi.framework.nodes.Node;

public abstract class BaseRamlGrammar
extends BaseGrammar {
    public static final String USES_KEY_NAME = "uses";
    public static final String RESOURCE_TYPES_KEY_NAME = "resourceTypes";
    public static final String TRAITS_KEY_NAME = "traits";
    public static final String TYPES_KEY_NAME = "types";
    public static final String SCHEMAS_KEY_NAME = "schemas";
    public static final String QUERY_PARAMETERS_KEY_NAME = "queryParameters";
    public static final String QUERY_STRING_KEY_NAME = "queryString";
    public static final String SECURITY_SCHEMES_KEY_NAME = "securitySchemes";
    public static final String MIME_TYPE_REGEX = "([\\w\\d\\.\\-\\_\\+]+|\\*)\\/([\\w\\d\\.\\-\\_\\+]+|\\*);?([\\w\\d\\.\\-\\_\\+]+=[\\w\\d\\.\\-\\_\\+]+)?(\\s+[\\w\\d\\.\\-\\_\\+]+=[\\w\\d\\.\\-\\_\\+]+)*";
    public static final String OAUTH_1_0 = "OAuth 1.0";
    public static final String OAUTH_2_0 = "OAuth 2.0";

    public ObjectRule raml() {
        return this.untitledRaml().with(this.titleField().description("Short plain-text label for the API."));
    }

    protected NodeReferenceRule nodeRef(String referenceKey) {
        return new NodeReferenceRule(referenceKey);
    }

    public ObjectRule untitledRaml() {
        return this.objectType().with(this.descriptionField()).with(this.schemasField()).with(this.traitsField()).with(this.resourceTypesField()).with(this.securitySchemesField()).with(this.versionField()).with(this.baseUriField()).with(this.baseUriParametersField()).with(this.protocolsField()).with(this.mediaTypeField()).with(this.securedByField().description("The security schemes that apply to every resource and method in the API.")).with(this.resourceField()).with(this.fieldWithRequiredValue(this.documentationKey(), this.documentations())).then(RamlDocumentNode.class);
    }

    protected KeyValueRule baseUriParametersField() {
        return this.field(this.baseUriParametersKey(), this.parameters());
    }

    protected KeyValueRule baseUriField() {
        return this.field(this.baseUriKey(), (Rule)new UriTemplateValidationRule(this.ramlScalarValue()));
    }

    protected KeyValueRule docTitleField() {
        return this.requiredField(this.titleKey(), this.allOf(this.minLength(1), this.ramlScalarValue()));
    }

    protected KeyValueRule titleField() {
        return this.requiredField(this.titleKey(), this.titleValue());
    }

    protected Rule titleValue() {
        return this.allOf(this.ramlScalarValue(), this.minLength(1));
    }

    protected KeyValueRule resourceField() {
        return new KeyValueRule(this.resourceKey(), this.anyOf(this.resourceValue(), this.nullValue().then(new EmptyObjectNodeFactory()))).then(ResourceNode.class);
    }

    protected KeyValueRule versionField() {
        return this.field(this.versionKey(), this.ramlScalarValue());
    }

    protected Rule ramlScalarValue() {
        return this.scalarType();
    }

    protected KeyValueRule mediaTypeField() {
        return this.field(this.mediaTypeKey(), (Rule)this.mimeTypeRegex());
    }

    public ObjectRule resourceType() {
        ObjectRule resourceType2 = this.inNewContext(new Callable<ObjectRule>(){

            @Override
            public ObjectRule call() {
                return new RuleTraverser().traverse(BaseRamlGrammar.this.baseResourceValue().with(BaseRamlGrammar.this.field(BaseRamlGrammar.this.anyResourceTypeMethod(), (Rule)BaseRamlGrammar.this.methodValue())), BaseRamlGrammar.this.ruleParameterModifier());
            }
        });
        return resourceType2.with(0, this.usageField());
    }

    private Function<Rule, Boolean> ruleParameterModifier() {
        return new Function<Rule, Boolean>(){

            @Override
            @Nullable
            public Boolean apply(@Nonnull Rule input) {
                if (input instanceof ObjectRule) {
                    ((ObjectRule)input).with(0, BaseRamlGrammar.this.fieldParametrizedKey());
                } else if (input instanceof KeyValueRule) {
                    KeyValueRule keyValueRule = (KeyValueRule)input;
                    keyValueRule.setValueRule(BaseRamlGrammar.this.anyOf(BaseRamlGrammar.this.parametrizedValueRule(), keyValueRule.getValueRule()));
                    keyValueRule.cleanDefaultValue();
                } else if (input instanceof ArrayRule) {
                    ArrayRule arrayRule = (ArrayRule)input;
                    arrayRule.of(BaseRamlGrammar.this.anyOf(BaseRamlGrammar.this.parametrizedValueRule(), arrayRule.of()));
                }
                if (!BaseRamlGrammar.this.isReferenceFactory(input) && !BaseRamlGrammar.this.isOverlayFactory(input) && input.getFactory() != null) {
                    input.cleanFactory();
                }
                return true;
            }
        };
    }

    private boolean isOverlayFactory(Rule input) {
        return input.getFactory() instanceof OverlayableSimpleTypeFactory;
    }

    private boolean isReferenceFactory(@Nonnull Rule input) {
        return input.getFactory() instanceof NodeReferenceFactory || input.getFactory() instanceof TypeExpressionReferenceFactory;
    }

    public ObjectRule resourceTypeParamsResolved() {
        return this.baseResourceValue().with(this.usageField()).with((KeyValueRule)this.field(this.anyResourceTypeMethod(), (Rule)this.methodValue()).then(MethodNode.class));
    }

    public ObjectRule traitParamsResolved() {
        return this.objectType().with(this.descriptionField()).with(this.field(this.displayNameKey(), this.ramlScalarValue())).with(this.queryParametersField()).with(this.headersField()).with(this.responsesField()).with(this.bodyField()).with(this.protocolsField().description("A method can override the protocols specified in the resource or at the API root, by employing this property.")).with(this.isField().description("A list of the traits to apply to this method.")).with(this.securedByField().description("The security schemes that apply to this method.")).with(this.usageField());
    }

    protected Rule documentations() {
        return this.array(this.documentation());
    }

    public ObjectRule documentation() {
        return this.objectType().with(this.docTitleField().description("Title of documentation section.")).with(this.contentField().description("Content of documentation section."));
    }

    protected KeyValueRule contentField() {
        return this.requiredField(this.string("content"), this.ramlScalarValue());
    }

    protected Rule securitySchemes() {
        return this.objectType().with((KeyValueRule)this.field(this.scalarType(), (Rule)this.securityScheme()).then(SecuritySchemeNode.class));
    }

    public ObjectRule securityScheme() {
        return this.objectType().with(this.descriptionField()).with(this.requiredField(this.securitySchemeTypeKey(), this.anyOf(this.string(OAUTH_1_0).description("The API's authentication uses OAuth 1.0 as described in RFC5849 [RFC5849]"), this.string(OAUTH_2_0).description("The API's authentication uses OAuth 2.0 as described in RFC6749 [RFC6749]"), this.string("Basic Authentication").description("The API's authentication uses Basic Authentication as described in RFC2617 [RFC2617]"), this.string("Digest Authentication").description("The API's authentication uses Digest Authentication as described in RFC2617 [RFC2617]"), this.string("Pass Through").description("Headers or Query Parameters are passed through to the API based on a defined object."), this.regex("x-.+").description("The API's authentication uses an authentication method not listed above.")))).with(this.displayNameField()).with(this.field(this.string("describedBy"), (Rule)this.securitySchemePart())).with(this.when("type", this.is(this.anyOf(this.string(OAUTH_1_0), this.string(OAUTH_2_0))).add(this.requiredField(this.string("settings"), this.securitySchemeSettings()))));
    }

    protected ObjectRule securitySchemePart() {
        return this.objectType().with(this.displayNameField()).with(this.descriptionField()).with(this.field(this.headersKey(), this.parameters())).with(this.queryParametersField()).with(this.responsesField());
    }

    protected ObjectRule securitySchemeSettings() {
        return this.objectType().with(this.field(this.string("requestTokenUri"), this.ramlScalarValue())).with(this.field(this.string("tokenCredentialsUri"), this.ramlScalarValue())).with(this.field(this.string("accessTokenUri"), this.ramlScalarValue())).with(this.field(this.string("authorizationGrants"), (Rule)this.anyOf(this.authorizationGrantsValue(), this.array(this.authorizationGrantsValue())))).with(this.field(this.string("scopes"), (Rule)this.anyOf(this.scalarType(), this.array(this.scalarType()))));
    }

    protected Rule authorizationGrantsValue() {
        return this.scalarType();
    }

    protected Rule traitsValue() {
        return this.objectType().with((KeyValueRule)this.field(this.scalarType(), (Rule)this.trait()).then(TraitNode.class));
    }

    public ObjectRule trait() {
        ObjectRule trait = this.inNewContext(new Callable<ObjectRule>(){

            @Override
            public ObjectRule call() {
                return new RuleTraverser().traverse(BaseRamlGrammar.this.methodValue(), BaseRamlGrammar.this.ruleParameterModifier());
            }
        });
        return trait.with(0, this.usageField());
    }

    private RegexValueRule parametrizedValueRule() {
        return this.regex(StringTemplateExpressionTransformer.TEMPLATE_PATTERN).fullMatch(false);
    }

    private KeyValueRule fieldParametrizedKey() {
        return this.field(this.parametrizedValueRule(), (Rule)this.any());
    }

    protected Rule resourceTypes() {
        return this.objectType().with((KeyValueRule)this.field(this.scalarType(), (Rule)this.resourceType()).then(ResourceTypeNode.class));
    }

    protected ObjectRule resourceValue() {
        return this.named("resourceValue", new RuleFactory<ObjectRule>(){

            @Override
            public ObjectRule create() {
                return BaseRamlGrammar.this.baseResourceValue().with(BaseRamlGrammar.this.methodField()).with(BaseRamlGrammar.this.resourceField());
            }
        });
    }

    protected KeyValueRule methodField() {
        return new KeyValueRule(this.anyMethod(), this.anyOf(this.methodValue(), this.nullValue().then(new EmptyObjectNodeFactory()))).then(MethodNode.class);
    }

    protected ObjectRule baseResourceValue() {
        return this.objectType().with(this.displayNameField()).with(this.descriptionField()).with(this.isField().description("A list of the traits to apply to all methods declared (implicitly or explicitly) for this resource. ")).with(this.resourceTypeReferenceField()).with(this.securedByField().description("The security schemes that apply to all methods declared (implicitly or explicitly) for this resource.")).with(this.field(this.uriParametersKey(), this.parameters()));
    }

    protected ObjectRule methodValue() {
        return this.objectType().with(this.descriptionField()).with(this.displayNameField()).with(this.queryParametersField()).with(this.headersField()).with(this.responsesField()).with(this.bodyField()).with(this.protocolsField().description("A method can override the protocols specified in the resource or at the API root, by employing this property.")).with(this.isField().description("A list of the traits to apply to this method.")).with(this.securedByField().description("The security schemes that apply to this method."));
    }

    protected KeyValueRule queryParametersField() {
        return this.field(this.queryParametersKey(), this.parameters());
    }

    protected KeyValueRule responsesField() {
        return this.field(this.responseKey(), this.responses());
    }

    protected StringValueRule responseKey() {
        return this.string("responses").description("Information about the expected responses to a request");
    }

    protected StringValueRule queryStringKey() {
        return this.string(QUERY_STRING_KEY_NAME).description("Specifies the query string needed by this method. Mutually exclusive with queryParameters.");
    }

    protected StringValueRule queryParametersKey() {
        return this.string(QUERY_PARAMETERS_KEY_NAME).description("Detailed information about any query parameters needed by this method. Mutually exclusive with queryString.");
    }

    protected Rule responses() {
        return this.objectType().with(this.responseField());
    }

    protected KeyValueRule responseField() {
        return this.field(this.responseCodes(), (Rule)this.response());
    }

    protected ObjectRule response() {
        return this.objectType().with(this.displayNameField()).with(this.descriptionField()).with(this.headersField()).with(this.bodyField());
    }

    protected Rule body() {
        return this.objectType().with(this.mimeTypeField());
    }

    public KeyValueRule mimeTypeField() {
        return this.field(this.mimeTypeRegex(), this.mimeType());
    }

    public RegexValueRule mimeTypeRegex() {
        return this.regex(MIME_TYPE_REGEX).suggest("application/json").suggest("application/xml");
    }

    protected abstract Rule mimeType();

    protected Rule parameters() {
        return this.objectType().with(this.field(this.scalarType(), this.parameter()));
    }

    protected abstract Rule parameter();

    protected ExclusiveSiblingRule exclusiveWith(String key, String ... notAllowedSiblings) {
        return new ExclusiveSiblingRule(key, Sets.newHashSet(notAllowedSiblings));
    }

    protected KeyValueRule securitySchemesField() {
        return this.field(this.securitySchemesKey(), this.securitySchemesValue());
    }

    protected abstract Rule securitySchemesValue();

    protected StringValueRule securitySchemesKey() {
        return this.string(SECURITY_SCHEMES_KEY_NAME).description("Declarations of security schemes for use within this API.");
    }

    protected KeyValueRule schemasField() {
        return this.field(this.schemasKey(), this.schemasValue());
    }

    protected abstract Rule schemasValue();

    protected StringValueRule schemasKey() {
        return this.string(SCHEMAS_KEY_NAME).description(this.schemasDescription());
    }

    @Nonnull
    protected abstract String schemasDescription();

    protected KeyValueRule resourceTypesField() {
        return this.field(this.resourceTypesKey(), this.resourceTypesValue());
    }

    protected Rule resourceTypesValue() {
        return this.anyOf(this.array(this.resourceTypes()), this.resourceTypes()).then(new ArrayWrapperFactory());
    }

    protected StringValueRule resourceTypesKey() {
        return this.string(RESOURCE_TYPES_KEY_NAME).description("Declarations of resource types for use within this API.");
    }

    protected KeyValueRule traitsField() {
        return this.field(this.traitsKey(), this.traitsValue());
    }

    protected StringValueRule traitsKey() {
        return this.string(TRAITS_KEY_NAME).description("Declarations of traits for use within this API.");
    }

    protected KeyValueRule protocolsField() {
        return this.field(this.protocolsKey(), this.protocols());
    }

    protected StringValueRule protocolsKey() {
        return this.string("protocols").description("The protocols supported by the API.");
    }

    protected KeyValueRule bodyField() {
        return this.field(this.bodyKey(), (Rule)this.firstOf(this.whenChildIs(this.mimeTypeField(), this.body()), this.whenPresent("/mediaType", this.mimeType()))).then(BodyNode.class);
    }

    protected StringValueRule bodyKey() {
        return this.string("body").description("Some methods admit request bodies, which are described by this property.");
    }

    protected KeyValueRule headersField() {
        return this.field(this.headersKey(), this.parameters());
    }

    protected StringValueRule headersKey() {
        return this.string("headers").description("Detailed information about any request headers needed by this method.");
    }

    protected KeyValueRule descriptionField() {
        return this.field(this.descriptionKey(), this.descriptionValue());
    }

    protected Rule descriptionValue() {
        return this.ramlScalarValue();
    }

    protected KeyValueRule displayNameField() {
        return this.field(this.displayNameKey(), this.ramlScalarValue()).defaultValue(this.parentKey());
    }

    protected KeyValueRule securedByField() {
        AnyOfRule securitySchemeRef = this.anyOf(this.nullValue(), this.anyTypeReference(SECURITY_SCHEMES_KEY_NAME, SecuritySchemeRefNode.class, ParametrizedSecuritySchemeRefNode.class));
        return this.field(this.securedByKey(), this.anyOf(securitySchemeRef, this.array(securitySchemeRef)).then(new ArrayWrapperFactory()));
    }

    protected KeyValueRule usageField() {
        return this.field(this.string("usage"), this.ramlScalarValue());
    }

    protected KeyValueRule isField() {
        Rule traitRef = this.anyTypeReference(TRAITS_KEY_NAME, TraitRefNode.class, ParametrizedTraitRefNode.class);
        return this.field(this.isKey(), this.anyOf(traitRef, this.array(traitRef)).then(new ArrayWrapperFactory()));
    }

    protected KeyValueRule resourceTypeReferenceField() {
        return this.field(this.resourceTypeRefKey(), this.anyTypeReference(RESOURCE_TYPES_KEY_NAME, ResourceTypeRefNode.class, ParametrizedResourceTypeRefNode.class));
    }

    protected Rule anyTypeReference(String referenceKey, Class<? extends Node> simpleClass, Class<? extends Node> parametrisedClass) {
        KeyValueRule paramsRule = this.field(this.scalarType(), (Rule)this.any());
        KeyValueRule typeWithParams = this.field(this.scalarType(), (Rule)this.objectType().with(paramsRule));
        NodeReferenceFactory factory = new NodeReferenceFactory(simpleClass);
        NodeReferenceFactory parametrisedFactory = new NodeReferenceFactory(parametrisedClass);
        return this.anyOf(this.nodeRef(referenceKey).then(factory), new ParametrizedNodeReferenceRule(referenceKey).with(typeWithParams).then(parametrisedFactory));
    }

    protected StringValueRule titleKey() {
        return this.string("title");
    }

    protected Rule resourceKey() {
        RegexValueRule rule = this.regex("/.*").label("/Resource").suggest("/<cursor>").description("The resources of the API, identified as relative URIs that begin with a slash (/). Every property whose key begins with a slash (/), and is either at the root of the API definition or is the child property of a resource property, is a resource property, e.g.: /users, /{groupId}, etc");
        return new UriTemplateValidationRule(rule);
    }

    protected StringValueRule usesKey() {
        return this.string(USES_KEY_NAME).description("Importing libraries.");
    }

    protected StringValueRule uriParametersKey() {
        return this.string("uriParameters").description("Detailed information about any URI parameters of this resource");
    }

    protected StringValueRule securedByKey() {
        return this.string("securedBy");
    }

    protected StringValueRule typeKey() {
        return this.string("type").description("The resource type which this resource inherits.");
    }

    protected StringValueRule securitySchemeTypeKey() {
        return this.string("type").description("Specify the security mechanism.");
    }

    protected StringValueRule resourceTypeRefKey() {
        return this.string("type").description("The resource type which this resource inherits.");
    }

    protected StringValueRule isKey() {
        return this.string("is");
    }

    protected StringValueRule displayNameKey() {
        return this.string("displayName").description("An alternate, human-friendly name for the method (in the resource's context).");
    }

    protected StringValueRule descriptionKey() {
        return this.string("description").description("A longer, human-friendly description of the API");
    }

    protected StringValueRule documentationKey() {
        return this.string("documentation").description("Additional overall documentation for the API.");
    }

    protected StringValueRule mediaTypeKey() {
        return this.string("mediaType").description("The default media type to use for request and response bodies (payloads), e.g. \"application/json\".");
    }

    protected StringValueRule baseUriParametersKey() {
        return this.string("baseUriParameters").description("Named parameters used in the baseUri (template).");
    }

    protected StringValueRule baseUriKey() {
        return this.string("baseUri").description("A URI that's to be used as the base of all the resources' URIs. Often used as the base of the URL of each resource, containing the location of the API. Can be a template URI.");
    }

    protected StringValueRule versionKey() {
        return this.string("version").description("The version of the API, e.g. \"v1\".");
    }

    protected AnyOfRule anyMethod() {
        return this.anyOf(this.string("get"), this.string("patch"), this.string("put"), this.string("post"), this.string("delete"), this.string("options"), this.string("head"));
    }

    protected AnyOfRule anyOptionalMethod() {
        return this.anyOf(this.string("get?"), this.string("patch?"), this.string("put?"), this.string("post?"), this.string("delete?"), this.string("options?"), this.string("head?"));
    }

    protected AnyOfRule anyResourceTypeMethod() {
        return this.anyOf(this.anyMethod(), this.anyOptionalMethod());
    }

    protected Rule protocols() {
        AnyOfRule protocols = this.anyOf(this.string("HTTP").caseSensitive(false), this.string("HTTPS").caseSensitive(false));
        return this.anyOf(protocols, this.array(protocols)).then(new ArrayWrapperFactory());
    }

    protected Rule responseCodes() {
        return this.allOf(this.range(100, 599));
    }
}

