/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.impl.commons.phase;

import org.raml.v2.internal.impl.commons.nodes.AnnotationNode;
import org.raml.v2.internal.impl.commons.nodes.AnnotationReferenceNode;
import org.raml.v2.internal.impl.commons.nodes.DocumentationItemNode;
import org.raml.v2.internal.impl.commons.nodes.ExampleDeclarationNode;
import org.raml.v2.internal.impl.commons.nodes.ExtendsNode;
import org.raml.v2.internal.impl.commons.nodes.OverlayableNode;
import org.raml.v2.internal.impl.commons.nodes.RamlDocumentNode;
import org.raml.v2.internal.impl.v10.nodes.LibraryLinkNode;
import org.raml.yagi.framework.grammar.rule.ErrorNodeFactory;
import org.raml.yagi.framework.nodes.ArrayNode;
import org.raml.yagi.framework.nodes.DefaultPosition;
import org.raml.yagi.framework.nodes.KeyValueNode;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.nodes.NullNode;
import org.raml.yagi.framework.nodes.ObjectNode;
import org.raml.yagi.framework.nodes.SimpleTypeNode;
import org.raml.yagi.framework.util.NodeSelector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtensionsMerger {
    private static final Logger logger = LoggerFactory.getLogger(ExtensionsMerger.class);
    private boolean overlay;

    public ExtensionsMerger(boolean overlay) {
        this.overlay = overlay;
    }

    public void merge(Node baseNode, Node copyNode) {
        if (baseNode instanceof ObjectNode && copyNode instanceof ObjectNode) {
            this.merge((ObjectNode)baseNode, (ObjectNode)copyNode);
        } else if (baseNode instanceof ArrayNode && copyNode instanceof ArrayNode) {
            this.merge((ArrayNode)baseNode, (ArrayNode)copyNode);
        } else {
            throw new RuntimeException(String.format("Merging not supported for nodes of type %s and %s", baseNode.getClass().getSimpleName(), copyNode.getClass().getSimpleName()));
        }
    }

    private void merge(ArrayNode baseNode, ArrayNode copyNode) {
        for (Node child : copyNode.getChildren()) {
            baseNode.addChild(child);
        }
    }

    private void merge(ObjectNode baseNode, ObjectNode copyNode) {
        for (Node child : copyNode.getChildren()) {
            if (!(child instanceof KeyValueNode)) {
                throw new RuntimeException("only expecting KeyValueNode");
            }
            Node keyNode = ((KeyValueNode)child).getKey();
            String key = keyNode.toString();
            if (this.shouldIgnoreNode(child)) {
                logger.debug("Ignoring key '{}'", (Object)key);
                continue;
            }
            Node valueNode = ((KeyValueNode)child).getValue();
            Node node = NodeSelector.selectFrom(NodeSelector.encodePath(key), (Node)baseNode);
            if (node == null) {
                this.overlayCheck(valueNode, valueNode);
                logger.debug("Adding key '{}'", (Object)key);
                baseNode.addChild(child);
                continue;
            }
            if (valueNode instanceof NullNode) {
                logger.debug("Ignoring null value for key '{}'", (Object)key);
                continue;
            }
            if (valueNode instanceof LibraryLinkNode) {
                logger.debug("Ignoring already defined library '{}'", (Object)key);
                continue;
            }
            if (child instanceof AnnotationNode) {
                logger.debug("Replacing annotation '{}'", (Object)key);
                ((KeyValueNode)node.getParent()).setValue(valueNode);
                continue;
            }
            if (child instanceof ExampleDeclarationNode) {
                logger.debug("Replacing example '{}'", (Object)key);
                ((KeyValueNode)node.getParent()).setValue(valueNode);
                continue;
            }
            if (DefaultPosition.isDefaultNode(child)) {
                logger.debug("Ignoring default key '{}'", (Object)key);
                continue;
            }
            if (valueNode instanceof SimpleTypeNode) {
                if (!this.overlayCheck(node, valueNode)) continue;
                logger.debug("Replacing existing scalar key '{}'", (Object)key);
                node.replaceWith(valueNode);
                continue;
            }
            logger.debug("Merging values '{}' and '{}'", (Object)node.getParent(), (Object)child);
            this.merge(node, valueNode);
        }
    }

    private boolean overlayCheck(Node baseNode, Node overlayNode) {
        boolean check = true;
        if (this.overlay && !this.isOverlayableNode(overlayNode)) {
            baseNode.replaceWith(ErrorNodeFactory.createInvalidOverlayNode(overlayNode));
            check = false;
        }
        return check;
    }

    private boolean isOverlayableNode(Node overlayNode) {
        Node parent = overlayNode.getParent();
        if (overlayNode instanceof OverlayableNode || parent instanceof OverlayableNode) {
            return true;
        }
        if (parent instanceof KeyValueNode && ((KeyValueNode)parent).getKey() instanceof AnnotationReferenceNode) {
            return true;
        }
        if (this.isLibraryNode(overlayNode)) {
            return true;
        }
        return !overlayNode.getChildren().isEmpty() && overlayNode.getChildren().get(0) instanceof DocumentationItemNode;
    }

    private boolean isLibraryNode(Node overlayNode) {
        boolean isLibrary = false;
        if (overlayNode instanceof LibraryLinkNode) {
            isLibrary = true;
        } else if (overlayNode.getParent() instanceof KeyValueNode) {
            isLibrary = this.isNode(overlayNode.getParent(), "uses");
        }
        return isLibrary;
    }

    private boolean shouldIgnoreNode(Node node) {
        if (node instanceof ExtendsNode) {
            return true;
        }
        return this.isNode(node, "usage");
    }

    private boolean isNode(Node node, String keyName) {
        Node keyNode = ((KeyValueNode)node).getKey();
        String key = ((SimpleTypeNode)keyNode).getLiteralValue();
        return keyName.equals(key) && node.getParent() instanceof RamlDocumentNode;
    }
}

